<?php

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Route;

return [

    /*
    |--------------------------------------------------------------------------
    | Sidebar Menu
    |--------------------------------------------------------------------------
    | المفاتيح المدعومة:
    | - text: نص العنصر
    | - url: رابط مباشر
    | - route: اسم Route (اختياري بدل url)
    | - icon: Bootstrap Icon class
    | - is_header: عنوان قسم
    | - is_divider: فاصل
    | - children: عناصر فرعية
    | - roles: مصفوفة أسماء أدوار مطلوبة
    | - can: صلاحية Spatie Permission واحدة
    | - can_any: مصفوفة صلاحيات على طريقة Gate::any
    | - active: مصفوفة patterns لتحديد الـ active state
    | - badge: Closure ترجع رقم/نص (اختياري)
    | - visible: Closure ترجع bool لإخفاء/إظهار بنود معينة
    */

    'menu' => [

        // ===== Overview =====
        ['text' => 'Overview', 'is_header' => true],

        [
            'text'   => 'Dashboard',
            'icon'   => 'bi bi-cpu',
            'url'    => '/',
            'active' => ['/', '/pages/index'],
        ],
        [
            'text'   => 'Analytics',
            'icon'   => 'bi bi-bar-chart',
            'url'    => '/analytics',
            'active' => ['/analytics*'],
        ],

        // ===== Work =====
        ['text' => 'Work', 'is_header' => true],

        // Organization block
        [
            'text' => 'Organization',
            'icon' => 'bi bi-diagram-3',
            'children' => [
                [
                    'text'   => 'Org Browser',
                    'url'    => '/departments-teams',
                    'active' => ['/departments-teams*', '/org*'],
                    'icon'   => 'bi bi-diagram-3',
                ],
                [
                    'text'   => 'Departments',
                    'url'    => '/departments',
                    'active' => ['/departments*'],
                    'icon'   => 'bi bi-columns-gap',
                ],
                [
                    'text'   => 'Teams',
                    'url'    => '/teams',
                    'active' => ['/teams*'],
                    'icon'   => 'bi bi-people',
                    'can'    => 'teams.view',
                ],
                [
                    'text'   => 'HR Attendance Dashboard',
                    'url'    => '/hr/attendance/dashboard',
                    'active' => ['/hr/attendance/dashboard*'],
                    'icon'   => 'bi bi-clipboard2-check',
                    // مثال صلاحية لو عندك واحدة للـ HR:
                    'can_any' => ['attendance.hr', 'attendance.view.all'],
                ],
            ],
        ],

        // ===== Attendance =====
[
    'text' => 'Attendance',
    'icon' => 'bi bi-clipboard-check',
    'active' => ['/attendance/me*', '/profile/attendance*'],
    'children' => [
        [
            'text'   => 'My Home Attendance',
            'route'  => 'attendance.me.page',
            'icon'   => 'bi bi-person-badge',
            'active' => ['/attendance/me*'],
            // 'can'  => 'attendance.view.self', // لو عندك صلاحية
        ],
        [
            'text'   => 'All (Attendances)',
            'route'  => 'profile.attendance.all',
            'icon'   => 'bi bi-clock-history',
            'active' => ['/profile/attendance*'],
            // 'can'  => 'attendance.view.profile', // اختياري
        ],

        // // === Home Attendance (POST Actions) ===
        // [
        //     'text'       => 'Home Check-In',
        //     'icon'       => 'bi bi-house-door',
        //     'post_route' => 'attendance.home.checkin', // << route POST
        //     'class'      => 'accent-success',
        //     // 'can'      => 'attendance.home', // لو عندك صلاحية
        // ],
        // [
        //     'text'       => 'Home Check-Out',
        //     'icon'       => 'bi bi-house-exclamation',
        //     'post_route' => 'attendance.home.checkout', // << route POST
        //     'class'      => 'accent-danger',
        //     // 'can'      => 'attendance.home',
        // ],
    ],
],

        // Attendance
        ['text' => 'Attendance', 'is_header' => true],

        // Vacations
        [
            'text' => 'Vacations',
            'icon' => 'bi bi-umbrella',
            'active' => ['/dashboard/attendance/vacations*'],
            'children' => [
                [
                    'text'   => 'All Vacations',
                    'route'  => 'vacations.index',
                    'icon'   => 'bi bi-list-check',
                    // مثال badge اختياري (غيّره لو عندك كاونتر):
                    'badge'  => fn() => null,
                ],
                [
                    'text'  => 'Create Request',
                    'route' => 'vacations.create',
                    'icon'  => 'bi bi-plus-circle',
                ],
            ],
        ],

        // Permits (حضور/انصراف استئذانات)
        [
            'text'   => 'Permits',
            'icon'   => 'bi bi-person-check',
            'active' => ['/dashboard/attendance/permits*', '/permits*'],
            'children' => [
                [
                    'text'  => 'All Permits',
                    'url'   => '/dashboard/attendance/permits',
                    'icon'  => 'bi bi-list-ul',
                ],
                [
                    'text'  => 'Create Permit',
                    'url'   => '/dashboard/attendance/permits/create',
                    'icon'  => 'bi bi-plus-square',
                    'visible' => fn() => Route::has('permits.store'), // مثال
                ],
            ],
        ],

        // ===== Communication =====
        ['text' => 'Communication', 'is_header' => true],

        [
            'text'   => 'Email',
            'icon'   => 'bi bi-envelope',
            'active' => ['/email*', '/mailbox*'],
            'children' => [
                ['text' => 'Inbox',   'route' => 'email.inbox',   'icon' => 'bi bi-inbox'],
                ['text' => 'Compose', 'route' => 'email.compose', 'icon' => 'bi bi-pencil-square'],
                // أدوات صحة البريد
                [
                    'text'   => 'Email Tools',
                    'icon'   => 'bi bi-tools',
                    'children' => [
                        ['text' => 'Health Check', 'route' => 'email.tools.health', 'icon' => 'bi bi-heart-pulse'],
                        ['text' => 'DNS Health',   'route' => 'email.tools.dns',    'icon' => 'bi bi-qr-code-scan'],
                    ],
                ],
            ],
        ],

        // ===== Team Lead =====
        [
            'text'  => 'Team Lead',
            'is_header' => true,
            'visible' => fn() => auth()->check() && auth()->user()->hasRole('Team Lead'),
        ],
        [
            'text'   => 'Team Dashboard',
            'icon'   => 'bi bi-speedometer2',
            'url'    => '/team-lead/dashboard',
            'roles'  => ['Team Lead'],
            'active' => ['/team-lead/dashboard*'],
        ],

        // ===== System / Admin =====
        ['is_divider' => true],
        ['text' => 'Admin & System', 'is_header' => true],

        [
            'text'   => 'Roles & Permissions',
            'icon'   => 'bi bi-shield-lock',
            'url'    => '/system/roles',
            'can'    => 'roles.manage',
            'active' => ['/system/roles*'],
        ],
        [
            'text'   => 'Telescope',
            'icon'   => 'bi bi-telescope',
            'url'    => '/telescope',
            'roles'  => ['Admin'],
            'active' => ['/telescope*'],
        ],

        // ===== Tools (اختياري) =====
        ['is_divider' => true],
        ['text' => 'Tools', 'is_header' => true],

        [
            'text'   => 'Widgets',
            'icon'   => 'bi bi-columns-gap',
            'url'    => '/widgets',
            'active' => ['/widgets*'],
        ],
        [
            'text'   => 'Map',
            'icon'   => 'bi bi-compass',
            'url'    => '/map',
            'active' => ['/map*'],
            'visible' => fn() => Route::has('map'), // مثال إخفاء لو مش موجودة
        ],
        [
            'text'   => 'Landing Page',
            'icon'   => 'bi bi-diagram-3',
            'url'    => '/landing',
            'active' => ['/landing*'],
            'visible' => fn() => Route::has('landing'), // مثال
        ],

        // ===== Account =====
        ['is_divider' => true],
        ['text' => 'Account', 'is_header' => true],

        [
            'text'   => 'Profile',
            'icon'   => 'bi bi-people',
            'url'    => '/profile',
            'active' => ['/profile*'],
        ],
        [
            'text'   => 'Calendar',
            'icon'   => 'bi bi-calendar4',
            'url'    => '/calendar',
            'active' => ['/calendar*'],
            'visible' => fn() => Route::has('calendar'),
        ],
        [
            'text'   => 'Settings',
            'icon'   => 'bi bi-gear',
            'url'    => '/settings',
            'active' => ['/settings*'],
            'visible' => fn() => Route::has('settings'),
        ],
        [
            'text'   => 'Helper',
            'icon'   => 'bi bi-gem',
            'url'    => '/helper',
            'active' => ['/helper*'],
            'visible' => fn() => Route::has('helper'),
        ],

        // ملاحظة: Route /logout عندك POST — اعمل زر يسلم فورم مخفي
        [
            'text'   => 'Logout',
            'icon'   => 'bi bi-box-arrow-right',
            'url'    => '/logout',
            'active' => [],
            'visible' => fn() => auth()->check(),
        ],
    ],
];


// return [

//     /*
//     |--------------------------------------------------------------------------
//     | View Storage Paths
//     |--------------------------------------------------------------------------
//     |
//     | Most templating systems load templates from disk. Here you may specify
//     | an array of paths that should be checked for your views. Of course
//     | the usual Laravel view path has already been registered for you.
//     |
//     */

//     'menu' => [[
//         'text' => 'Navigation',
//         'is_header' => true
//     ], [
//         'url' => '/',
//         'icon' => 'bi bi-cpu',
//         'text' => 'Dashboard'
//     ], [
//         'url' => '/analytics',
//         'icon' => 'bi bi-bar-chart',
//         'text' => 'Analytics'
//     ], [
//         'url' => '/departments',
//         'icon' => 'bi bi-building',
//         'text' => 'Departments'
//     ], [
//         'icon' => 'bi bi-envelope',
//         'text' => 'Email',
//         'children' => [[
//             'url' => '/email/inbox',
//             'action' => 'Inbox',
//             'text' => 'Inbox'
//         ], [
//             'url' => '/email/compose',
//             'action' => 'Compose',
//             'text' => 'Compose'
//         ], [
//             'url' => '/email/detail',
//             'action' => 'Detail',
//             'text' => 'Detail'
//         ]]
//     ], [
//         'is_divider' => true
//     ], [
//         'text' => 'Components',
//         'is_header' => true
//     ], [
//         'url' => '/widgets',
//         'icon' => 'bi bi-columns-gap',
//         'text' => 'Widgets'
//     ],
// //    [
// //       'icon' => 'bi bi-people',
// //      'text' => 'system Dashboard',
// //      'highlight' => true,
// //      'children' => [[
// //          'url' => '/system-dashboard/management',
// //          'text' => 'Management',
// //        ], [
// //          'url' => '/system-dashboard/attendance',
// //          'text' => 'Attendance',
// //        ], [
// //          'url' => '/system-dashboard/request',
// //          'text' => 'Request',
// //        ]]
// //    ],
//         [
//             'icon' => 'bi bi-people',
//             'text' => 'System Dashboard',
//             'highlight' => true,
//             'children' => [
//                 [
//                     'text' => 'Management',
//                     'url' => '/system-dashboard/management',
//                     'children' => [
//                         [
//                             'url' => '/system-dashboard/management/employees.blade.php',
//                             'text' => 'Employees',
//                         ],
//                         [
//                             'url' => '/system-dashboard/management/departments',
//                             'text' => 'Departments',
//                         ], [
//                             'url' => '/system-dashboard/management/companies',
//                             'text' => 'Companies',
//                         ], [
//                             'url' => '/system-dashboard/management/team-leaders',
//                             'text' => 'Team Leaders',
//                         ],
//                         // You can add more sub-items like roles, teams, etc.
//                         // [
//                         //     'url' => '/system-dashboard/management/roles',
//                         //     'text' => 'Roles',
//                         // ],
//                     ]
//                 ],
//                 [
//                     'url' => '/system-dashboard/attendance',
//                     'text' => 'Attendance',
//                 ],
//                 [
//                     'url' => '/system-dashboard/request',
//                     'text' => 'Request',
//                 ]
//             ]
//         ], [
//             'icon' => 'bi bi-bag-check',
//             'text' => 'POS System',
//             'highlight' => true,
//             'children' => [[
//                 'url' => '/pos/customer-order',
//                 'text' => 'Customer Order'
//             ], [
//                 'url' => '/pos/kitchen-order',
//                 'text' => 'Kitchen Order'
//             ], [
//                 'url' => '/pos/counter-checkout',
//                 'text' => 'Counter Checkout'
//             ], [
//                 'url' => '/pos/table-booking',
//                 'text' => 'Table Booking'
//             ], [
//                 'url' => '/pos/menu-stock',
//                 'text' => 'Menu Stock'
//             ]]
//         ], [
//             'icon' => 'fa fa-heart',
//             'text' => 'UI Kits',
//             'children' => [[
//                 'url' => '/ui/bootstrap',
//                 'text' => 'Bootstrap'
//             ], [
//                 'url' => '/ui/buttons',
//                 'text' => 'Buttons'
//             ], [
//                 'url' => '/ui/card',
//                 'text' => 'Card'
//             ], [
//                 'url' => '/ui/icons',
//                 'text' => 'Icons'
//             ], [
//                 'url' => '/ui/modal-notifications',
//                 'text' => 'Modal & Notifications'
//             ], [
//                 'url' => '/ui/typography',
//                 'text' => 'Typography'
//             ], [
//                 'url' => '/ui/tabs-accordions',
//                 'text' => 'Tabs & Accordions'
//             ]]
//         ], [
//             'icon' => 'bi bi-pen',
//             'text' => 'Forms',
//             'children' => [[
//                 'url' => '/form/elements',
//                 'text' => 'Form Elements'
//             ], [
//                 'url' => '/form/plugins',
//                 'text' => 'Form Plugins'
//             ], [
//                 'url' => '/form/wizards',
//                 'text' => 'Wizards'
//             ]]
//         ], [
//             'icon' => 'bi bi-grid-3x3',
//             'text' => 'Tables',
//             'children' => [[
//                 'url' => '/table/elements',
//                 'text' => 'Table Elements'
//             ],
//                 [
//                     'url' => '/table/plugins',
//                     'text' => 'Table Plugins'
//                 ]]
//         ], [
//             'icon' => 'bi bi-pie-chart',
//             'text' => 'Charts',
//             'children' => [[
//                 'url' => '/chart/chart-js',
//                 'text' => 'Chart.js'
//             ], [
//                 'url' => '/chart/chart-apex',
//                 'text' => 'Apexcharts.js'
//             ]]
//         ], [
//             'url' => '/map',
//             'icon' => 'bi bi-compass',
//             'text' => 'Map'
//         ], [
//             'url' => 'Layout',
//             'icon' => 'bi bi-layout-sidebar',
//             'text' => 'Layout',
//             'children' => [[
//                 'url' => '/layout/starter-page',
//                 'text' => 'Starter Page'
//             ], [
//                 'url' => '/layout/fixed-footer',
//                 'text' => 'Fixed Footer'
//             ], [
//                 'url' => '/layout/full-height',
//                 'text' => 'Full Height'
//             ], [
//                 'url' => '/layout/full-width',
//                 'text' => 'Full Width'
//             ], [
//                 'url' => '/layout/boxed-layout',
//                 'text' => 'Boxed Layout'
//             ], [
//                 'url' => '/layout/collapsed-sidebar',
//                 'text' => 'Collapsed Sidebar'
//             ], [
//                 'url' => '/layout/top-nav',
//                 'text' => 'Top Nav'
//             ], [
//                 'url' => '/layout/mixed-nav',
//                 'text' => 'Mixed Nav'
//             ], [
//                 'url' => '/layout/mixed-nav-boxed-layout',
//                 'text' => 'Mixed Nav Boxed Layout'
//             ]]
//         ], [
//             'icon' => 'bi bi-collection',
//             'text' => 'Pages',
//             'children' => [[
//                 'url' => '/page/scrum-board',
//                 'text' => 'Scrum Board'
//             ], [
//                 'url' => '/page/products',
//                 'text' => 'Products'
//             ], [
//                 'url' => '/page/product/details',
//                 'text' => 'Product Details'
//             ], [
//                 'url' => '/page/orders',
//                 'text' => 'Orders'
//             ], [
//                 'url' => '/page/order/details',
//                 'text' => 'Order Details'
//             ], [
//                 'url' => '/page/gallery',
//                 'text' => 'Gallery'
//             ], [
//                 'url' => '/page/search-results',
//                 'text' => 'Search Results'
//             ], [
//                 'url' => '/page/coming-soon',
//                 'text' => 'Coming Soon Page'
//             ], [
//                 'url' => '/page/error',
//                 'text' => 'Error Page'
//             ], [
//                 'url' => '/page/login',
//                 'text' => 'Login'
//             ], [
//                 'url' => '/page/register',
//                 'text' => 'Register'
//             ], [
//                 'url' => '/page/messenger',
//                 'text' => 'Messenger'
//             ], [
//                 'url' => '/page/data-management',
//                 'text' => 'Data Management'
//             ]]
//         ], [
//             'icon' => 'bi bi-people',
//             'text' => 'Departments & Teams',
//             'url' => '/departments-teams'
//         ], [
//             'icon' => 'bi bi-telescope',
//             'text' => 'Telescope',
//             'url' => '/telescope',
//             'role' => 'admin'
//         ], [
//             'is_divider' => true
//         ], [
//             'text' => 'Users',
//             'is_header' => true
//         ], [
//             'url' => '/profile',
//             'icon' => 'bi bi-people',
//             'text' => 'Profile'
//         ], [
//             'url' => '/calendar',
//             'icon' => 'bi bi-calendar4',
//             'text' => 'Calendar'
//         ], [
//             'url' => '/settings',
//             'icon' => 'bi bi-gear',
//             'text' => 'Settings'
//         ], [
//             'url' => '/helper',
//             'icon' => 'bi bi-gem',
//             'text' => 'Helper'
//         ], [
//             'url' => '/logout',
//             'icon' => 'bi bi-box-arrow-right',
//             'text' => 'Logout'
//         ]
//     ]
// ];



// return [
//     'menu' => [

//         // ===== Top =====
//         ['text' => 'Navigation', 'is_header' => true],

//         ['url' => '/',           'icon' => 'bi bi-cpu',       'text' => 'Dashboard'],
//         ['url' => '/analytics',  'icon' => 'bi bi-bar-chart', 'text' => 'Analytics'],

//         // ===== Organization =====
//         ['text' => 'Organization', 'is_header' => true],
//         [
//             'icon' => 'bi bi-diagram-3',
//             'text' => 'Organization',
//             'children' => [
//                 // مستكشف الهيكل (الشجرة + الموظفين بالـ AJAX)
//                 ['url' => '/departments-teams', 'text' => 'Org Browser'],
//                 // إدارة الأقسام (لوحة CRUD تقليدية)
//                 ['url' => '/departments',       'text' => 'Departments'],
//                 // إدارة الفرق (لو متاحة)
//                 ['url' => '/teams',             'text' => 'Teams', 'can' => 'teams.view'],
//             ],
//         ],
//         // إدارة الأدوار والصلاحيات (للـ Admin أو من معاه صلاحية roles.manage)
//         ['url' => '/roles', 'icon' => 'bi bi-shield-lock', 'text' => 'Roles & Permissions', 'roles' => ['Admin'], 'can' => 'roles.manage'],

//         // ===== Email =====
//         [
//             'icon' => 'bi bi-envelope',
//             'text' => 'Email',
//             'children' => [
//                 ['url' => '/email/inbox',   'text' => 'Inbox'],
//                 ['url' => '/email/compose', 'text' => 'Compose'],
//                 ['url' => '/email/detail',  'text' => 'Detail'],
//             ],
//         ],

//         // ===== Components =====
//         ['is_divider' => true],
//         ['text' => 'Components', 'is_header' => true],
//         ['url' => '/widgets', 'icon' => 'bi bi-columns-gap', 'text' => 'Widgets'],

//         [
//             'icon' => 'bi bi-controller', 'text' => 'UI Kits',
//             'children' => [
//                 ['url' => '/ui/bootstrap',        'text' => 'Bootstrap'],
//                 ['url' => '/ui/buttons',          'text' => 'Buttons'],
//                 ['url' => '/ui/card',             'text' => 'Card'],
//                 ['url' => '/ui/icons',            'text' => 'Icons'],
//                 ['url' => '/ui/modal-notifications', 'text' => 'Modal & Notifications'],
//                 ['url' => '/ui/typography',       'text' => 'Typography'],
//                 ['url' => '/ui/tabs-accordions',  'text' => 'Tabs & Accordions'],
//             ],
//         ],

//         [
//             'icon' => 'bi bi-pen', 'text' => 'Forms',
//             'children' => [
//                 ['url' => '/form/elements', 'text' => 'Form Elements'],
//                 ['url' => '/form/plugins',  'text' => 'Form Plugins'],
//                 ['url' => '/form/wizards',  'text' => 'Wizards'],
//             ],
//         ],

//         [
//             'icon' => 'bi bi-grid-3x3', 'text' => 'Tables',
//             'children' => [
//                 ['url' => '/table/elements', 'text' => 'Table Elements'],
//                 ['url' => '/table/plugins',  'text' => 'Table Plugins'],
//             ],
//         ],

//         [
//             'icon' => 'bi bi-pie-chart', 'text' => 'Charts',
//             'children' => [
//                 ['url' => '/chart/chart-js',   'text' => 'Chart.js'],
//                 ['url' => '/chart/chart-apex', 'text' => 'Apexcharts.js'],
//             ],
//         ],

//         ['url' => '/map',     'icon' => 'bi bi-compass',        'text' => 'Map'],
//         ['url' => '/landing', 'icon' => 'bi bi-diagram-3',      'text' => 'Landing Page'],

//         // Telescope — للـ Admin فقط (لاحظ الكابيتال)
//         ['url' => '/telescope', 'icon' => 'bi bi-telescope', 'text' => 'Telescope', 'roles' => ['Admin']],

//         // ===== Users =====
//         ['is_divider' => true],
//         ['text' => 'Users', 'is_header' => true],
//         ['url' => '/profile',  'icon' => 'bi bi-people',    'text' => 'Profile'],
//         ['url' => '/calendar', 'icon' => 'bi bi-calendar4', 'text' => 'Calendar'],
//         ['url' => '/settings', 'icon' => 'bi bi-gear',      'text' => 'Settings'],
//         ['url' => '/helper',   'icon' => 'bi bi-gem',       'text' => 'Helper'],
//         ['url' => '/logout',   'icon' => 'bi bi-box-arrow-right', 'text' => 'Logout'],
//     ],
// ];



// return [
//     'menu' => [

//         // ===== Top =====
//         ['text' => 'Navigation', 'is_header' => true],

//         ['url' => '/',          'icon' => 'bi bi-cpu',       'text' => 'Dashboard'],
//         ['url' => '/analytics', 'icon' => 'bi bi-bar-chart', 'text' => 'Analytics'],

//         // ===== System =====
// ['text' => 'System', 'is_header' => true],
// [
//     'url'  => '/system/roles',
//     'icon' => 'bi bi-shield-lock',
//     'text' => 'Roles & Permissions',
//     'can'  => 'roles.manage',
// ],
// [
//     'url'  => '/team-lead/dashboard',
//     'icon' => 'bi bi-speedometer2',
//     'text' => 'Team Dashboard',
//     'roles' => ['Team Lead'],
// ],

//         // ===== Organization =====
//         ['text' => 'Organization', 'is_header' => true],
//         [
//             'icon' => 'bi bi-diagram-3',
//             'text' => 'Organization',
//             'children' => [
//                 ['url' => '/departments-teams', 'text' => 'Org Browser'],
//                 ['url' => '/departments',       'text' => 'Departments'],
//                 ['url' => '/teams',             'text' => 'Teams', 'can' => 'teams.view'],
//                 // HR Manager Attendance Routes
//                 ['url' => '/hr/attendance/dashboard', 'text' => 'HR Attendance Dashboard'],
//             ],
//         ],

//         // ===== Attendance / Vacations =====
//         ['text' => 'Attendance', 'is_header' => true],
//         [
//             'icon' => 'bi bi-umbrella', // أو bi bi-airplane / bi bi-backpack حسب ذوقك
//             'text' => 'Vacations',
//             'children' => [
//                 // القائمة العامة
//                 ['url' => '/dashboard/attendance/vacations',        'text' => 'All Vacations'],
//                 // إنشاء طلب
//                 ['url' => '/dashboard/attendance/vacations/create', 'text' => 'Create Request'],
//             ],
//         ],


//         // ===== Email =====
//         [
//             'icon' => 'bi bi-envelope',
//             'text' => 'Email',
//             'children' => [
//                 ['url' => '/email/inbox',   'text' => 'Inbox'],
//                 ['url' => '/email/compose', 'text' => 'Compose'],
//                 ['url' => '/email/detail',  'text' => 'Detail'],
//             ],
//         ],

//         // ===== Components =====
//         ['is_divider' => true],
//         ['text' => 'Components', 'is_header' => true],
//         ['url' => '/widgets', 'icon' => 'bi bi-columns-gap', 'text' => 'Widgets'],

//         [
//             'icon' => 'bi bi-controller', 'text' => 'UI Kits',
//             'children' => [
//                 ['url' => '/ui/bootstrap',           'text' => 'Bootstrap'],
//                 ['url' => '/ui/buttons',             'text' => 'Buttons'],
//                 ['url' => '/ui/card',                'text' => 'Card'],
//                 ['url' => '/ui/icons',               'text' => 'Icons'],
//                 ['url' => '/ui/modal-notifications', 'text' => 'Modal & Notifications'],
//                 ['url' => '/ui/typography',          'text' => 'Typography'],
//                 ['url' => '/ui/tabs-accordions',     'text' => 'Tabs & Accordions'],
//             ],
//         ],

//         [
//             'icon' => 'bi bi-pen', 'text' => 'Forms',
//             'children' => [
//                 ['url' => '/form/elements', 'text' => 'Form Elements'],
//                 ['url' => '/form/plugins',  'text' => 'Form Plugins'],
//                 ['url' => '/form/wizards',  'text' => 'Wizards'],
//             ],
//         ],

//         [
//             'icon' => 'bi bi-grid-3x3', 'text' => 'Tables',
//             'children' => [
//                 ['url' => '/table/elements', 'text' => 'Table Elements'],
//                 ['url' => '/table/plugins',  'text' => 'Table Plugins'],
//             ],
//         ],

//         [
//             'icon' => 'bi bi-pie-chart', 'text' => 'Charts',
//             'children' => [
//                 ['url' => '/chart/chart-js',   'text' => 'Chart.js'],
//                 ['url' => '/chart/chart-apex', 'text' => 'Apexcharts.js'],
//             ],
//         ],

//         ['url' => '/map',     'icon' => 'bi bi-compass',   'text' => 'Map'],
//         ['url' => '/landing', 'icon' => 'bi bi-diagram-3', 'text' => 'Landing Page'],

//         // Telescope — Admin only
//         ['url' => '/telescope', 'icon' => 'bi bi-telescope', 'text' => 'Telescope', 'roles' => ['Admin']],

//         // ===== Users =====
//         ['is_divider' => true],
//         ['text' => 'Users', 'is_header' => true],
//         ['url' => '/profile',  'icon' => 'bi bi-people',    'text' => 'Profile'],
//         ['url' => '/calendar', 'icon' => 'bi bi-calendar4', 'text' => 'Calendar'],
//         ['url' => '/settings', 'icon' => 'bi bi-gear',      'text' => 'Settings'],
//         ['url' => '/helper',   'icon' => 'bi bi-gem',       'text' => 'Helper'],
//         ['url' => '/logout',   'icon' => 'bi bi-box-arrow-right', 'text' => 'Logout'],
//     ],
// ];


// return [
//     /*
//     |--------------------------------------------------------------------------
//     | Sidebar Menu (HUD)
//     |--------------------------------------------------------------------------
//     | نفس البنية اللي بيقرأها blade عندك:
//     | - is_header / is_divider
//     | - text / url / icon / target
//     | - children: [] (قائمة فرعية)
//     | - role: اسم رول واحد  | roles: [..] | can: 'perm' or ['perm1','perm2']
//     |
//     | NOTE:
//     | - استخدمنا urls نسبية (بدون / في الأول) عشان دالتك menuIsActive بتعمل match
//     | - أي مجموعة فيها children لازم تحط url برضه (الأولاد بياخدوا الـ active لو اتفتحوا)
//     */

//     'menu' => [

//         // ===== Dashboard / Home (مثال – لو عندك صفحة رئيسية)
//         [
//             'is_header' => true,
//             'text'      => 'الرئيسية',
//         ],
//         [
//             'text'  => 'لوحة التحكم',
//             'url'   => '', // "/" مكافئ، خليها فاضية عشان request()->is('') يلتقط الـhome
//             'icon'  => 'bi bi-speedometer2',
//         ],

//         // ===== Attendance
//         [
//             'is_header' => true,
//             'text'      => 'الحضور و الانصراف',
//         ],
//         [
//             'text'     => 'الإجازات',
//             'url'      => 'dashboard/attendance/vacations',
//             'icon'     => 'bi bi-calendar2-week',
//             'children' => [
//                 [
//                     'text' => 'كل الطلبات',
//                     'url'  => 'dashboard/attendance/vacations',
//                 ],
//                 [
//                     'text' => 'طلب جديد',
//                     'url'  => 'dashboard/attendance/vacations/create',
//                     // لو حابب تقفلها على موظفين معينين سيبها لاحقًا بـ 'can' أو 'roles'
//                 ],
//                 // لو عايز “طلباتي” كفلتر:
//                 // [
//                 //     'text' => 'طلباتي',
//                 //     'url'  => 'dashboard/attendance/vacations?mine=1',
//                 // ],
//             ],
//         ],

//         // ===== Security / Roles
//         [
//             'is_header' => true,
//             'text'      => 'الأمان و الصلاحيات',
//         ],
//         [
//             'text'     => 'إدارة الأدوار',
//             'url'      => 'dashboard/security/roles',
//             'icon'     => 'bi bi-shield-lock',
//             // مثال للتحكم بالظهور:
//             // 'roles'  => ['Admin'], // يحتاج user->hasAnyRole
//             // أو:
//             // 'can'    => ['manage roles', 'roles.update'], // أي صلاحية من دول تكفي
//             'children' => [
//                 [
//                     'text' => 'المستخدمون & الأدوار',
//                     'url'  => 'dashboard/security/roles',
//                 ],
//                 // لو عندك صفحات تانية (تعريف أدوار/صلاحيات) ضيفها هنا
//                 // [
//                 //     'text' => 'الأدوار (تعريف)',
//                 //     'url'  => 'dashboard/security/roles/definitions',
//                 //     'roles'=> ['Admin'],
//                 // ],
//             ],
//         ],

//         // ===== Help
//         [
//             'is_header' => true,
//             'text'      => 'مساعدة',
//         ],
//         [
//             'text'   => 'التوثيق',
//             'url'    => 'https://seantheme.com/hud/helper.html',
//             'icon'   => 'bi bi-book',
//             'target' => '_blank',
//         ],
//     ],
// ];
