<?php

use Laravel\Telescope\Http\Middleware\Authorize;
use Laravel\Telescope\Watchers;

return [

    /*
    |--------------------------------------------------------------------------
    | Telescope Master Switch
    |--------------------------------------------------------------------------
    |
    | This option may be used to disable all Telescope watchers regardless
    | of their individual configuration, which simply provides a single
    | and convenient way to enable or disable Telescope data storage.
    |
    */

    'enabled' => false,

    /*
    |--------------------------------------------------------------------------
    | Telescope Domain
    |--------------------------------------------------------------------------
    |
    | This is the subdomain where Telescope will be accessible from. If the
    | setting is null, Telescope will reside under the same domain as the
    | application. Otherwise, this value will be used as the subdomain.
    |
    */

    'domain' => env('TELESCOPE_DOMAIN'),

    /*
    |--------------------------------------------------------------------------
    | Telescope Path
    |--------------------------------------------------------------------------
    |
    | This is the URI path where Telescope will be accessible from. Feel free
    | to change this path to anything you like. Note that the URI will not
    | affect the paths of its internal API that aren't exposed to users.
    |
    */

    'path' => 'telescope',

    /*
    |--------------------------------------------------------------------------
    | Telescope Storage Driver
    |--------------------------------------------------------------------------
    |
    | This configuration options determines the storage driver that will
    | be used to store Telescope's data. In addition, you may set any
    | custom options as needed by the particular driver you choose.
    |
    */

    'driver' => 'database',

    'storage' => [
        'database' => [
            'connection' => env('DB_CONNECTION', 'mysql'),
            'chunk' => 1000,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Telescope Route Middleware
    |--------------------------------------------------------------------------
    |
    | These middleware will be assigned to every Telescope route, giving you
    | the chance to add your own middleware to this list or change any of
    | the existing middleware. Or, you can simply stick with this list.
    |
    */

    'middleware' => [
        'web',
    ],

    /*
    |--------------------------------------------------------------------------
    | Allowed / Ignored Paths & Commands
    |--------------------------------------------------------------------------
    |
    | The following array lists the URI paths and Artisan commands that will
    | not be watched by Telescope. In addition to this list, some Laravel
    | commands, like migrations and queue commands, are always ignored.
    |
    */

    'only_paths' => [],

    'ignore_paths' => [],

    'ignore_commands' => [],

    /*
    |--------------------------------------------------------------------------
    | Telescope Watchers
    |--------------------------------------------------------------------------
    |
    | The following array lists the "watchers" that will be registered with
    | Telescope. The watchers gather the application's profile data when
    | a request or task is executed. Feel free to customize this list.
    |
    */

    'watchers' => [
        Watchers\BatchWatcher::class => true,

        Watchers\CacheWatcher::class => [
            'enabled' => true,
            'hidden' => [],
        ],

        Watchers\ClientRequestWatcher::class => true,

        Watchers\CommandWatcher::class => [
            'enabled' => true,
            'ignore' => [],
        ],

        Watchers\DumpWatcher::class => [
            'enabled' => true,
            'always' => true, // Always show dumps
        ],

        Watchers\EventWatcher::class => [
            'enabled' => true,
            'ignore' => [],
        ],

        Watchers\ExceptionWatcher::class => true,

        Watchers\GateWatcher::class => [
            'enabled' => true,
            'ignore_abilities' => [],
            'ignore_packages' => false,
            'ignore_paths' => [],
        ],

        Watchers\JobWatcher::class => true,

        Watchers\LogWatcher::class => [
            'enabled' => true,
            'level' => null, // Log all levels
        ],

        Watchers\MailWatcher::class => true,

        Watchers\ModelWatcher::class => [
            'enabled' => true,
            'events' => [
                'eloquent.*',
                'creating', 'created',
                'updating', 'updated',
                'deleting', 'deleted',
                'restoring', 'restored',
            ],
            'hydrations' => true,
        ],

        Watchers\NotificationWatcher::class => true,

        Watchers\QueryWatcher::class => [
            'enabled' => true,
            'ignore_packages' => false,
            'ignore_paths' => [],
            'slow' => 50, // Log queries taking longer than 50ms
        ],

        Watchers\RedisWatcher::class => true,

        Watchers\RequestWatcher::class => [
            'enabled' => true,
            'size_limit' => 1024, // Increased size limit for better monitoring
            'ignore_http_methods' => [],
            'ignore_status_codes' => [],
        ],

        Watchers\ScheduleWatcher::class => true,
        Watchers\ViewWatcher::class => true,
    ],
];
