<?php

namespace Database\Factories;

use App\Models\Department;
use Illuminate\Database\Eloquent\Factories\Factory;

class DepartmentFactory extends Factory
{
    protected $model = Department::class;

    public function definition(): array
    {
        $name = $this->faker->unique()->randomElement([
            'Graphic', 'Video Editors', 'Content', 'Tech', 'Media Buying'
        ]);

        return [
            'name'       => $name,
            'code'       => strtoupper(substr($name,0,3)).'-'.fake()->unique()->numberBetween(100,999),
            'parent_id'  => null,
            'depth'      => 0,
            'path'       => null,
            'color_code' => null,
            'is_active'  => true,
        ];
    }
}
