<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Department;
use App\Models\Employee;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class EmployeeFactory extends Factory
{
    protected $model = Employee::class;

    public function definition(): array
    {
        // اختر فرع عشوائي (عدّل حسب فروعك الفعلية)
        $branchId = $this->faker->numberBetween(1, 5);

        // اسمين وهميين
        $first = $this->faker->firstName();
        $last  = $this->faker->lastName();

        return [
            'employee_code' => "x_(EMP-{$branchId}-".strtoupper(Str::random(4)).")",
            'branch_id'     => $branchId,

            // نربط بيوزر Dummy وعليه وسم x_ (الإيميل بدون أقواس علشان صالح)
            'user_id'       => User::factory()->state(function () use ($first, $last) {
                $slug = strtolower($first.'.'.$last.'.'.Str::random(5));
                return [
                    'name'     => "x_({$first} {$last})",
                    'email'    => "x_{$slug}@example.test",
                    'password' => bcrypt('password'), // للتجربة فقط
                ];
            }),

            // قسم عشوائي (لو عايز تخصيص، سيبه للسييدر)
            'department_id' => Department::factory(),

            'first_name'    => "x_({$first})",
            'last_name'     => "x_({$last})",
            'hire_date'     => $this->faker->dateTimeBetween('-5 years', 'now')->format('Y-m-d'),
            'status'        => 'active', // أو ['active','inactive','on_leave']
        ];
    }

    // حالة سريعة لموظف بدون User (لو حبيت تختبر)
    public function withoutUser(): self
    {
        return $this->state(fn () => ['user_id' => null]);
    }
}
