<?php

namespace Database\Factories;

use App\Models\TeamMember;
use App\Models\Department;
use Illuminate\Database\Eloquent\Factories\Factory;

class TeamMemberFactory extends Factory
{
    protected $model = TeamMember::class;

    public function definition(): array
    {
        $first = $this->faker->firstName;
        $last  = $this->faker->lastName;

        return [
            'employee_code' => (string)$this->faker->unique()->numberBetween(1000,999999),
            'first_name'    => $first,
            'last_name'     => $last,
            'name'          => "$first $last",
            'role'          => 'member',
            'department_id' => Department::inRandomOrder()->value('id'),
            'manager_id'    => null,
            'email'         => $this->faker->safeEmail(),
            'phone'         => $this->faker->phoneNumber(),
            'hire_date'     => $this->faker->date(),
            'status'        => 'active',
        ];
    }
}
