<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class UserFactory extends Factory
{
    protected $model = User::class;

    public function definition(): array
    {
        $name = "x_(".$this->faker->name().")";
        $email = 'x_'.Str::of($this->faker->unique()->safeEmail())->replace(['(',')'], '');

        return [
            'name'              => $name,
            'email'             => (string) $email,
            'email_verified_at' => now(),
            'password'          => bcrypt('password'),
            'mobile'            => $this->faker->e164PhoneNumber(),
            'status'            => 1,
            'remember_token'    => Str::random(10),

            // سيبهم فاضيين (لو هتختبر الإيميل الداخلي بعدين)
            'imap_username'            => null,
            'imap_password_encrypted'  => null,
        ];
    }
}
