<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('media_links', function (Blueprint $table) {
            $table->id();

            $table->string('domain');
            $table->string('default_language', 2);

            // English fields
            $table->string('en_logo')->nullable();
            $table->string('en_title')->nullable();
            $table->json('en_colors')->nullable();
            $table->json('en_social_media_links')->nullable();
            $table->json('en_contact')->nullable();
            $table->string('en_qr_code')->nullable();

            // Arabic fields
            $table->string('ar_logo')->nullable();
            $table->string('ar_title')->nullable();
            $table->json('ar_colors')->nullable();
            $table->json('ar_social_media_links')->nullable();
            $table->json('ar_contact')->nullable();
            $table->string('ar_qr_code')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('media_links');
    }
};
