<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::dropIfExists('users');

        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->string('name');
            $table->string('email')->nullable()->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');

            // اختياري
            $table->string('mobile')->nullable();
            $table->text('avatar')->nullable();

            // تكاملات
            // $table->foreignId('company_id')->nullable()->constrained('companies')->nullOnDelete()->cascadeOnUpdate();
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete()->cascadeOnUpdate();

            // بريد داخلي (IMAP)
            $table->string('imap_username')->nullable();
            $table->text('imap_password_encrypted')->nullable();

            // حالة
            $table->tinyInteger('status')->default(1); // 1=active

            $table->rememberToken();
            $table->timestamps();

            // فهارس مفيدة
            // $table->index('company_id');
            $table->index('created_by');
            $table->index('status');
        });
    }

    public function down(): void {
        Schema::dropIfExists('users');
    }
};
