<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesTable extends Migration
{
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->string('employee_code');
            $table->integer('branch_id');
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->date('hire_date')->nullable();
            $table->enum('status', ['active', 'inactive', 'on_leave'])->default('active');
            $table->timestamps();

            $table->unique(['employee_code', 'branch_id']); // Composite unique key
            $table->index(['employee_code', 'branch_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
