<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('_x_test_attendances', function (Blueprint $table) {
            $table->id();
            $table->string('employee_name')->nullable();
            $table->string('employee_code'); // Correct ID
            $table->dateTime('check_time');
            $table->integer('branch_id'); // SENSORID
            $table->string('branch_name')->nullable();
            $table->timestamps();
            $table->unique(['employee_code', 'check_time', 'branch_id']); // تجنب duplicates
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('_x_test_attendances');
    }
};
