<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('import_states', function (Blueprint $table) {
            $table->id();
            $table->string('source_key')->unique();   // ex: 'final_sheet'
            $table->unsignedBigInteger('last_row')->default(1); // آخر صف متعالَج في Final (الهيدر = 1)
            $table->timestamp('last_imported_at')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
    });

        // Insert initial state for 'final_sheet'
        DB::table('import_states')->insert([
            'source_key' => 'final_sheet',
            'last_row' => 1,
            'last_imported_at' => now(),
            'meta' => json_encode(['total_rows' => 36512]), // Assuming total rows is 36512
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('import_states');
        // Optionally, you can also delete the initial state if needed
    }
};
