<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttendanceLogsTable extends Migration
{
    public function up()
    {
        Schema::create('attendance_logs', function (Blueprint $table) {
            $table->id();
            $table->string('employee_code');
            $table->datetime('check_time');
            $table->integer('branch_id');
            $table->enum('type', ['check_in', 'check_out'])->default('check_in');
            $table->enum('source', ['device', 'home'])->default('device');
            $table->string('employee_name')->nullable();
            $table->string('branch_name')->nullable();
            $table->timestamps();

            $table->unique(['employee_code', 'check_time', 'branch_id']);
            $table->index(['employee_code', 'check_time', 'branch_id']);
            $table->foreign(['employee_code', 'branch_id'])->references(['employee_code', 'branch_id'])->on('employees')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('attendance_logs');
    }
}
