<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{


    public function up()
    {
       Schema::create('performance_logs', function (Blueprint $table) {
            $table->id();
            $table->string('employee_code');
            $table->integer('branch_id');
            $table->date('check_time'); // تغيير لـ date بدل datetime
            $table->decimal('hours_worked', 5, 2)->nullable();
            $table->enum('status', ['present', 'absent', 'late'])->default('present');
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->unique(['employee_code', 'branch_id', 'check_time']);
            $table->index(['employee_code', 'branch_id', 'check_time']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('performance_logs');
    }
};
