<?php
// database/migrations/2025_08_27_122349_create_departments_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('departments', function (Blueprint $t) {
      $t->id();
      $t->string('name');
      $t->string('code', 50)->unique();
      // مفيش constrained هنا
      $t->unsignedBigInteger('parent_id')->nullable();

      $t->unsignedInteger('depth')->default(0);
      $t->string('path', 500)->nullable();
      $t->string('color_code', 7)->nullable();
      $t->boolean('is_active')->default(true);
      $t->timestamps();
      $t->softDeletes();

      // اختياري: اندكس عادي (مش ضروري لو هتضيف FK بعدين)
      $t->index('parent_id', 'idx_departments_parent_id');
      $t->index('is_active');
      $t->index('path');
    });

    // أضف الـ FK باسم فريد وواضح
    Schema::table('departments', function (Blueprint $t) {
      $t->foreign('parent_id', 'fk_departments_parent_self')
        ->references('id')->on('departments')
        ->nullOnDelete(); // ON DELETE SET NULL
    });
  }

  public function down(): void {
    // لازم نفك الـ FK قبل drop
    Schema::table('departments', function (Blueprint $t) {
      // فك القيد لو موجود
      try { $t->dropForeign('fk_departments_parent_self'); } catch (\Throwable $e) {}
    });
    Schema::dropIfExists('departments');
  }
};
