<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('landing_form_tracking', function (Blueprint $table) {
            $table->id();
            $table->string('name', 44);
            $table->string('mobile', 21);
            $table->text('address');
            $table->text('services');
            $table->string('services_for', 44)->default('The Same Account');
            $table->string('account_name', 21);
            $table->string('platform_info', 21);
            $table->string('platform_ip_1', 41);
            $table->string('platform_ip_2', 41);
            $table->string('ip_lat', 21);
            $table->string('ip_lng', 21);
            $table->string('ip_country', 21);
            $table->string('ip_city', 21);
            $table->string('ip_region', 44);
            $table->string('tracking_code', 44)->default('0');
            $table->string('voucher_id', 22)->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('landing_form_tracking');
    }
};
