<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reservations', function (Blueprint $table) {
            $table->id();
            $table->string('phone', 21);
            $table->string('service');
            $table->string('account_name', 21)->nullable();
            $table->string('platform_info', 21)->nullable();
            $table->string('platform_ip_1', 41)->nullable();
            $table->string('platform_ip_2', 41)->nullable();
            $table->string('ip_lat', 21)->nullable();
            $table->string('ip_lng', 21)->nullable();
            $table->string('ip_country', 21)->nullable();
            $table->string('ip_city', 21)->nullable();
            $table->string('ip_region', 44)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reservations');
    }
};
