<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('btn_track', function (Blueprint $table) {
            $table->id();
            $table->string('account', 24);
            $table->string('platform', 24);
            $table->string('ip_1', 24);
            $table->string('ip_2', 24)->nullable();
            $table->string('click_type', 24)->nullable();
            $table->string('lat', 24)->nullable();
            $table->string('lng', 24)->nullable();
            $table->string('country', 24)->nullable();
            $table->string('city', 24)->nullable();
            $table->string('region', 24)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('btn_track');
    }
};
