<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('newsletter_subscribers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('account')->unsigned()->nullable();
            $table->string('platform', 22)->nullable();
            $table->string('email', 190);
            $table->string('name', 45)->nullable();
            $table->string('ip_1', 80)->nullable();
            $table->string('ip_2', 80)->nullable();
            $table->string('lat', 80)->nullable();
            $table->string('lng', 80)->nullable();
            $table->string('country', 80)->nullable();
            $table->string('city', 80)->nullable();
            $table->string('region', 80)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('newsletter_subscribers');
    }
};
