<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('email_drafts', function (Blueprint $t) {
            $t->id();
            $t->foreignId('user_id')->constrained()->cascadeOnDelete();
            $t->string('mode', 20)->default('new'); // new|reply|reply_all|forward
            $t->string('ref_uid')->nullable();
            $t->string('ref_folder')->nullable();

            $t->text('to')->nullable();
            $t->text('cc')->nullable();
            $t->text('bcc')->nullable();
            $t->string('subject')->nullable();

            $t->longText('body_html')->nullable();
            $t->longText('body_text')->nullable();

            $t->json('attachments')->nullable(); // [{name, path, mime, size}]
            $t->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('email_drafts');
    }
};
