<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Common tracking fields to add:
        $fields = function (Blueprint $table) {
            $table->string('source')->nullable()->after('updated_at');
            $table->string('medium')->nullable()->after('source');
            $table->string('campaign')->nullable()->after('medium');
            $table->string('term')->nullable()->after('campaign');
            $table->string('content')->nullable()->after('term');
            $table->string('referrer', 512)->nullable()->after('content');
            $table->string('page_url', 512)->nullable()->after('referrer');
            $table->string('visitor_id', 64)->nullable()->after('page_url');
        };

        // 1. landing_form_tracking
        Schema::table('landing_form_tracking', function (Blueprint $table) use ($fields) {
            $fields($table);
        });

        // 2. reservations
        Schema::table('reservations', function (Blueprint $table) use ($fields) {
            $fields($table);
        });

        // 3. newsletter_subscribers
        Schema::table('newsletter_subscribers', function (Blueprint $table) use ($fields) {
            $fields($table);
        });

        // 4. btn_track
        Schema::table('btn_track', function (Blueprint $table) use ($fields) {
            $fields($table);
        });
    }

    public function down(): void
    {
        // Fields to remove
        $fields = [
            'source', 'medium', 'campaign', 'term', 'content',
            'referrer', 'page_url', 'visitor_id'
        ];

        foreach ($fields as $column) {
            if (Schema::hasColumn('landing_form_tracking', $column)) {
                Schema::table('landing_form_tracking', function (Blueprint $table) use ($column) {
                    $table->dropColumn($column);
                });
            }
            if (Schema::hasColumn('reservations', $column)) {
                Schema::table('reservations', function (Blueprint $table) use ($column) {
                    $table->dropColumn($column);
                });
            }
            if (Schema::hasColumn('newsletter_subscribers', $column)) {
                Schema::table('newsletter_subscribers', function (Blueprint $table) use ($column) {
                    $table->dropColumn($column);
                });
            }
            if (Schema::hasColumn('btn_track', $column)) {
                Schema::table('btn_track', function (Blueprint $table) use ($column) {
                    $table->dropColumn($column);
                });
            }
        }
    }
};
