<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('employees', function (Blueprint $table) {
            // عمود القسم (مسموح يكون NULL في البداية علشان المايجريشن تمشي على الداتا الحالية)
            $table->foreignId('department_id')
                  ->nullable()
                  ->after('branch_id')
                  ->constrained('departments')
                  ->nullOnDelete()
                  ->cascadeOnUpdate();

            // فهرس مفيد للاستعلامات
            $table->index('department_id', 'idx_employees_department_id');
        });
    }

    public function down(): void {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropConstrainedForeignId('department_id'); // يسقط الـ FK والعمود لو DB حديثة
            // لو الإصدار ما بيسقطش العمود تلقائيًا:
            if (Schema::hasColumn('employees', 'department_id')) {
                $table->dropIndex('idx_employees_department_id');
                $table->dropColumn('department_id');
            }
        });
    }
};
