<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Add user_id to team_members for a 1-to-1 link
        Schema::table('team_members', function (Blueprint $t) {
            if (!Schema::hasColumn('team_members', 'user_id')) {
                $t->unsignedBigInteger('user_id')->nullable()->unique()->after('id');
                $t->foreign('user_id')->references('id')->on('users')->onDelete('set null');
            }
        });

        // Add unique constraint to team_memberships
        Schema::table('team_memberships', function (Blueprint $t) {
            // Drop the old unique index if it exists
            $t->dropUnique('uq_tms_team_member_joined');
            // Add the new unique index
            $t->unique(['team_id', 'team_member_id'], 'uq_tms_team_member');
        });

        // Remove team_id from users table
        Schema::table('users', function (Blueprint $t) {
            if (Schema::hasColumn('users', 'team_id')) {
                $t->dropColumn('team_id');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $t) {
            if (!Schema::hasColumn('users', 'team_id')) {
                $t->unsignedBigInteger('team_id')->nullable();
            }
        });

        Schema::table('team_memberships', function (Blueprint $t) {
            $t->dropUnique('uq_tms_team_member');
            $t->unique(['team_id','team_member_id','joined_at'], 'uq_tms_team_member_joined');
        });

        Schema::table('team_members', function (Blueprint $t) {
            if (Schema::hasColumn('team_members', 'user_id')) {
                $t->dropForeign(['user_id']);
                $t->dropColumn('user_id');
            }
        });
    }
};
