<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('vacation_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');                      // مثال: سنوية، مرضية، طارئة
            $table->string('code')->unique();           // annual, sick, emergency
            $table->unsignedTinyInteger('required_approvals')->default(1); // 1 أو 2
            $table->boolean('deducts_balance')->default(true);
            $table->unsignedSmallInteger('max_days_per_request')->nullable(); // اختياري
            $table->unsignedSmallInteger('max_days_per_year')->nullable();    // اختياري
            $table->boolean('weekend_excluded')->default(true); // استبعاد الجمعة/السبت عند الحساب
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('vacation_types');
    }
};
