<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('vacations', function (Blueprint $table) {
            $table->id();

            // الربط الأساسي بالموظف
            $table->foreignId('employee_id')->constrained()->cascadeOnDelete();

            // نوع الإجازة
            $table->foreignId('vacation_type_id')->constrained()->cascadeOnDelete();

            // تتبع من قام/اعتمد (Users كـ فاعلين)
            $table->foreignId('requested_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('leader_approved_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('hr_approved_by_user_id')->nullable()->constrained('users')->nullOnDelete();

            // المدة + الحساب
            $table->date('start_date');
            $table->date('end_date');
            $table->unsignedSmallInteger('total_days');

            // أسباب
            $table->text('member_reason')->nullable();
            $table->text('leader_reason')->nullable();
            $table->text('hr_reason')->nullable();

            // الحالة والمنطق
            $table->string('status')->index(); // pending|leader_approved|hr_approved|rejected
            $table->boolean('needs_hr')->default(true);

            $table->timestamps();

            // فهارس مفيدة
            $table->index(['employee_id', 'start_date', 'end_date']);
            $table->index(['vacation_type_id', 'status']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('vacations');
    }
};
