<?php

// database/migrations/2025_09_22_000001_add_leader_decision_to_vacations.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('vacations', function (Blueprint $t) {
            if (!Schema::hasColumn('vacations','leader_reason')) {
                $t->text('leader_reason')->nullable();
            }
            if (!Schema::hasColumn('vacations','leader_decision_at')) {
                $t->timestamp('leader_decision_at')->nullable()->index();
            }
            // (اختياري) تأكيد فهرس الحالة
            // if (Schema::hasColumn('vacations','status')) {
            //     $t->index('status');
            // }
        });
    }

    public function down(): void {
        Schema::table('vacations', function (Blueprint $t) {
            if (Schema::hasColumn('vacations','leader_decision_at')) $t->dropColumn('leader_decision_at');
            // ما نمسّش leader_reason لأنه قديم عندك
        });
    }
};
