<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('vacations', function (Blueprint $t) {
            if (!Schema::hasColumn('vacations','hr_decision_at')) {
                $t->timestamp('hr_decision_at')->nullable()->index();
            }
        });
    }
    public function down(): void {
        Schema::table('vacations', function (Blueprint $t) {
            if (Schema::hasColumn('vacations','hr_decision_at')) {
                $t->dropColumn('hr_decision_at');
            }
        });
    }
};
