<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('attendance_permit_types', function (Blueprint $t) {
            $t->id();
            $t->string('name');        // مثال: short_leave, early_exit, late_entry, medical, personal
            $t->string('display_name')->nullable(); // للواجهه
            $t->boolean('requires_proof')->default(false); // زي medical
            $t->boolean('count_as_work_time')->default(false); // حسب السياسة
            $t->timestamps();
            $t->unique('name');
        });
    }
    public function down(): void {
        Schema::dropIfExists('attendance_permit_types');
    }
};
