<?php
// database/migrations/2025_09_23_000010_create_attendance_permits_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('attendance_permits', function (Blueprint $t) {
            $t->id();

            // الربط الأساسي بالموظف
            $t->foreignId('employee_id')->constrained()->cascadeOnDelete();

            // نوع الإذن
            $t->foreignId('permit_type_id')->nullable()->constrained('attendance_permit_types')->nullOnDelete();

            // الفاعلون (Users كـ فاعلين)
            $t->foreignId('requested_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $t->foreignId('leader_approved_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $t->foreignId('hr_approved_by_user_id')->nullable()->constrained('users')->nullOnDelete();

            // المدة
            $t->dateTime('start_datetime');
            $t->dateTime('end_datetime');
            $t->boolean('all_day')->default(false);
            $t->unsignedMediumInteger('total_minutes')->nullable(); // اختياري للتقارير السريعة

            // أسباب
            $t->text('member_reason')->nullable();
            $t->text('leader_reason')->nullable();
            $t->text('hr_reason')->nullable();

            // الحالة والمنطق (نفس فلسفة vacations)
            $t->string('status')->index(); // pending|leader_approved|hr_approved|rejected|cancelled
            $t->boolean('needs_hr')->default(true);

            // طوابع القرار (زي ما عندك في vacations)
            $t->timestamp('leader_decision_at')->nullable()->index();
            $t->timestamp('hr_decision_at')->nullable()->index();

            // الإلغاء اختياري
            $t->foreignId('cancelled_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $t->text('cancelled_reason')->nullable();

            $t->timestamps();
            // $t->softDeletes(); // فعّل لو عايز

            // فهارس مركبة
            $t->index(['employee_id', 'start_datetime', 'end_datetime']);
            $t->index(['permit_type_id', 'status']);
        });
    }

    public function down(): void {
        Schema::dropIfExists('attendance_permits');
    }
};
