<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('attendance_daily', function (Blueprint $t) {
            $t->id();
            $t->string('employee_code', 64);
            $t->date('work_date');

            $t->timestampTz('first_in')->nullable();
            $t->enum('first_in_source', ['home', 'device', 'merged'])->nullable();

            $t->timestampTz('last_out')->nullable();
            $t->enum('last_out_source', ['home', 'device', 'merged'])->nullable();

            $t->unsignedSmallInteger('branch_id')->nullable();

            $t->timestamps();

            $t->unique(['employee_code', 'work_date']);
            $t->index(['branch_id', 'work_date']);
        });
    }
    public function down(): void
    {
        Schema::dropIfExists('attendance_daily');
    }
};
