<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('attendance_logs', function (Blueprint $t) {
            // لتسريع البناء والتقارير
            $t->index(['employee_code', 'check_time']);
            $t->index(['branch_id', 'check_time']);
            // مفتاح فريد يمنع الدوبلكيت لنفس الحدث
            $t->unique(['employee_code', 'branch_id', 'check_time', 'type'], 'uniq_emp_branch_time_type');
        });
    }
    public function down(): void
    {
        Schema::table('attendance_logs', function (Blueprint $t) {
            $t->dropIndex(['employee_code', 'check_time']);
            $t->dropIndex(['branch_id', 'check_time']);
            $t->dropUnique('uniq_emp_branch_time_type');
        });
    }
};
