<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contact', function (Blueprint $table) {
            $table->id();

            // Timestamps
            $table->timestamp('action_time');
            $table->timestamp('session_started_at');

            // Geo location data
            $table->string('geo_ip', 45); // Supports both IPv4 and IPv6
            $table->string('geo_country', 100);
            $table->string('geo_city', 100);
            $table->string('geo_region', 100);
            $table->decimal('geo_lat', 10, 7); // Precision for coordinates
            $table->decimal('geo_lon', 10, 7); // Precision for coordinates
            $table->string('geo_source', 50);

            // Platform and user agent
            $table->string('platform', 50);
            $table->text('user_agent_sample'); // Can be long

            // User submitted data
            $table->string('user_name', 100);
            $table->string('user_email', 255);
            $table->string('user_mobile', 20);
            $table->string('user_services', 100);

            // Laravel timestamps
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contact');
    }
};
