<?php

use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();

            $table->string('name');
            $table->string('email')->nullable();
            $table->string('title')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->enum('role', ['admin', 'user', 'manager'])->default('user');
            $table->string('mobile')->default('0')->nullable();
            $table->string('company_name')->nullable();
            $table->integer('company_id')->nullable()->index();
            $table->text('avatar')->nullable();
            $table->tinyInteger('type')->default(0);
            $table->string('sub_type')->nullable();
            $table->integer('created_by')->default(2);
            $table->integer('team_id')->default(0);
            $table->string('status')->default('0');
            $table->string('remember_token', 100)->nullable();

            $table->timestamps();
        });

        // Insert Admin
        // DB::table('users')->insert([
        //     'name' => 'Admin',
        //     'email' => 'admin@gmail.com',
        //     'password' => Hash::make('12345678'),
        //     'type' => 1,
        //     'created_by' => 1,
        //     'status' => 1,
        // ]);
    }

    public function down()
    {
        Schema::dropIfExists('users');
    }
}
