<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('branch_id')->constrained()->cascadeOnDelete();
            $table->dateTime('check_time'); // الوقت الفعلي للبصمة

            // للاحتفاظ بالخام للمراجعات
            $table->string('sensor_id')->nullable();
            $table->string('raw_user_id')->nullable();
            $table->string('raw_correct_id')->nullable();

            $table->timestamps();

            // منع التكرار عند إعادة الاستيراد
            $table->unique(['employee_id', 'branch_id', 'check_time']);
                });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};
