<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('team_members', function (Blueprint $t) {
      $t->id();
      $t->string('employee_code')->unique(); // لربط الحضور
      $t->string('first_name')->nullable();
      $t->string('last_name')->nullable();
      $t->string('name')->nullable(); // اسم كامل بديل
      $t->enum('role', ['admin','manager','member'])->default('member');

      $t->foreignId('department_id')->nullable()->constrained('departments')->nullOnDelete();
      $t->foreignId('manager_id')->nullable()->constrained('team_members')->nullOnDelete(); // المشرف المباشر

      $t->string('email')->nullable();
      $t->string('phone')->nullable();
      $t->date('hire_date')->nullable();
      $t->enum('status', ['active','inactive'])->default('active');

      $t->timestamps();
      $t->softDeletes();

      $t->index(['department_id']);
      $t->index(['manager_id']);
      $t->index(['status']);
    });
  }

  public function down(): void {
    Schema::dropIfExists('team_members');
  }
};
