<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::table('departments', function (Blueprint $t) {
      $t->foreignId('manager_id')->nullable()->after('parent_id')->constrained('team_members')->nullOnDelete();
      $t->index(['code']);
    });
  }

  public function down(): void {
    Schema::table('departments', function (Blueprint $t) {
      $t->dropConstrainedForeignId('manager_id');
    });
  }
};
