<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('teams', function (Blueprint $t) {
      $t->id();
      $t->string('name')->unique();
      $t->enum('type', ['squad','project','departmental'])->default('squad');
      $t->foreignId('account_manager_id')->nullable()->constrained('team_members')->nullOnDelete();
      $t->date('start_date')->nullable();
      $t->date('end_date')->nullable();
      $t->boolean('is_active')->default(true);
      $t->timestamps();
      $t->softDeletes();

      $t->index(['type']);
      $t->index(['is_active']);
    });
  }

  public function down(): void {
    Schema::dropIfExists('teams');
  }
};
