<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('team_memberships', function (Blueprint $t) {
      $t->id();
      $t->foreignId('team_id')->constrained('teams')->cascadeOnDelete();
      $t->foreignId('team_member_id')->constrained('team_members')->cascadeOnDelete();

      $t->enum('role_in_team', [
        'member','lead','account_manager','media_buyer','designer','editor','content','developer'
      ])->default('member');

      $t->date('joined_at')->nullable();
      $t->date('left_at')->nullable();
      $t->boolean('is_active')->default(true);

      $t->timestamps();

      $t->index(['team_id','team_member_id']);
      $t->index(['is_active']);

      // لمنع تكرار نفس العضوية بنفس تاريخ الانضمام عدة مرات (اختياري لكنه عملي)
      $t->unique(['team_id','team_member_id','joined_at'], 'uq_team_member_joined');
    });
  }

  public function down(): void {
    Schema::dropIfExists('team_memberships');
  }
};
