<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AttendancePermitType;

class AttendancePermitTypesSeeder extends Seeder
{
    public function run(): void
    {
        $types = [
            [
                'name'               => 'short_leave',
                'display_name'       => 'إذن قصير',
                'requires_proof'     => false,
                'count_as_work_time' => false,
            ],
            [
                'name'               => 'early_exit',
                'display_name'       => 'انصراف مبكر',
                'requires_proof'     => false,
                'count_as_work_time' => false,
            ],
            [
                'name'               => 'late_entry',
                'display_name'       => 'تأخير في الحضور',
                'requires_proof'     => false,
                'count_as_work_time' => false,
            ],
            [
                'name'               => 'medical',
                'display_name'       => 'إذن طبي',
                'requires_proof'     => true,
                'count_as_work_time' => false,
            ],
            [
                'name'               => 'personal',
                'display_name'       => 'ظرف شخصي',
                'requires_proof'     => false,
                'count_as_work_time' => false,
            ],
        ];

        foreach ($types as $t) {
            AttendancePermitType::firstOrCreate(
                ['name' => AttendancePermitType::normalizeName($t['name'])],
                [
                    'display_name'       => $t['display_name'] ?? null,
                    'requires_proof'     => (bool)($t['requires_proof'] ?? false),
                    'count_as_work_time' => (bool)($t['count_as_work_time'] ?? false),
                ]
            );
        }
    }
}
