<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Employee;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class DemoUsersSeeder extends Seeder
{
    public function run(): void
    {
        // بيانات أساسية
        $defaults = [
            'password' => Hash::make(env('DEMO_USERS_PASSWORD', 'password123')),
        ];

        // Helper لإنشاء/تحديث يوزر + رول + سجل موظف
        $makeUser = function (string $name, string $email, string $role, array $employeeInfo = []) use ($defaults) {
            $user = User::firstOrCreate(
                ['email' => $email],
                [
                    'name' => $name,
                    'password' => $defaults['password'],
                    // لو عندك حقول إضافية في users ضيفها هنا مع قيم افتراضية
                ]
            );

            if (!$user->hasRole($role)) {
                $user->assignRole($role);
            }

            // تحضير بيانات employees
            $empData = array_merge([
                'user_id'      => $user->id,
                'first_name'   => Str::before($name, ' ') ?: $name,
                'last_name'    => Str::after($name, ' ') ?: '',
                'employee_code' => 'EMP-' . strtoupper(Str::random(6)),
            ], $employeeInfo);

            // معالجة أعمدة إجبارية محتملة
            if (Schema::hasColumn('employees', 'branch_id') && !isset($empData['branch_id'])) {
                // حاول استخدم 1 كـ HQ، أو عدّلها حسب سيستمك
                $empData['branch_id'] = 1;
            }

            // حقول ممكن تكون موجودة عندك
            foreach (['gender', 'phone', 'department_id', 'team_leader_id'] as $maybeCol) {
                if (Schema::hasColumn('employees', $maybeCol) && !isset($empData[$maybeCol])) {
                    // سيبها فاضية إلا لو عايز قيمة افتراضية معيّنة
                }
            }

            Employee::firstOrCreate(
                ['user_id' => $user->id],
                $empData
            );

            return $user;
        };

        // === الأربعة يوزرز ===
        $makeUser('System Admin',   'admin@yousrygroup.local', 'Admin');
        $makeUser('HR Manager',     'hr@yousrygroup.local',    'HR');
        $makeUser('Team Leader',    'lead@yousrygroup.local',  'TeamLeader');
        $makeUser('Demo Employee',  'employee@yousrygroup.local', 'Employee');
    }
}
