<?php

namespace Database\Seeders;

use App\Models\Department;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class DepartmentSeeder extends Seeder
{
    public function run(): void
    {
        DB::transaction(function () {
            // ألوان مقترحة سريعة (عدّل براحتك)
            $palette = [
                'Developers'        => '#0c7a7a',
                'Frontend'          => '#14b8a6',
                'Backend'           => '#0ea5e9',
                'Content Creator'   => '#f47b46',
                'Moderator'         => '#3b82f6',
                'Media Buyer'       => '#a855f7',
                'Graphic Designer'  => '#ef4444',
                'Audio / Video'     => '#10b981',
                'Sales'             => '#f59e0b',
                'Account Managers'  => '#64748b',
            ];

            // شجرة الأقسام (تقدر تزود Children برحتك)
            $tree = [
                [
                    'name' => 'Developers', 'code' => 'DEV', 'children' => [
                        ['name' => 'Frontend', 'code' => 'DEV-FE'],
                        ['name' => 'Backend',  'code' => 'DEV-BE'],
                    ]
                ],
                ['name' => 'Content Creator',  'code' => 'CNT'],
                ['name' => 'Moderator',        'code' => 'MOD'],
                ['name' => 'Media Buyer',      'code' => 'MB'],
                ['name' => 'Graphic Designer', 'code' => 'GD'],
                ['name' => 'Audio / Video',    'code' => 'AV'],
                ['name' => 'Sales',            'code' => 'SLS'],
                ['name' => 'Account Managers', 'code' => 'AM'],
            ];

            $seedNode = function (array $node, ?Department $parent) use (&$seedNode, $palette) {
                $code = $node['code'] ?? strtoupper(Str::slug($node['name'], '_'));

                // إنشاء/تحديث القسم بناءً على code (Unique عندك)
                $dept = Department::firstOrCreate(
                    ['code' => $code],
                    [
                        'name'        => $node['name'],
                        'parent_id'   => optional($parent)->id,
                        'manager_id'  => null,
                        'color_code'  => $palette[$node['name']] ?? null,
                        'is_active'   => 1,
                        'depth'       => 0,   // هنحسبها بعد ما نعرف الـid
                        'path'        => null // هنحسبها بعد الحفظ
                    ]
                );

                // لو الاسم/الألوان/الأب اتغيروا نحدّثهم
                $updates = [];
                if ($dept->name !== $node['name'])                          $updates['name'] = $node['name'];
                if ($dept->parent_id !== optional($parent)->id)              $updates['parent_id'] = optional($parent)->id;
                if (($palette[$node['name']] ?? null) !== $dept->color_code) $updates['color_code'] = $palette[$node['name']] ?? null;
                if (!empty($updates)) $dept->update($updates);

                // حساب depth و path (path = سلسلة IDs من الجذر للفرع الحالي)
                $depth = $parent ? ($parent->depth + 1) : 0;
                $path  = $parent ? ($parent->path ? $parent->path.'/'.$dept->id : $parent->id.'/'.$dept->id) : (string)$dept->id;

                if ($dept->depth !== $depth || $dept->path !== $path) {
                    $dept->depth = $depth;
                    $dept->path  = $path;
                    $dept->save();
                }

                foreach ($node['children'] ?? [] as $child) {
                    $seedNode($child, $dept);
                }
            };

            foreach ($tree as $node) {
                $seedNode($node, null);
            }
        });
    }
}
