<?php

namespace Database\Seeders;

use App\Models\Department;
use App\Models\Employee;
use Illuminate\Database\Seeder;

class DummyEmployeeSeeder extends Seeder
{
    public function run(): void
    {
        // تأكد إن الأقسام موجودة (لو محتاج)
        if (Department::count() === 0) {
            $this->call(DepartmentSeeder::class);
        }

        // هات كل الأقسام الحالية
        $departments = Department::orderBy('id')->get(['id','name']);

        // عدد موظفين لكل قسم (عدّلها براحتك)
        $perDept = 3;

        foreach ($departments as $dept) {
            Employee::factory()
                ->count($perDept)
                // إجبار التعيين على القسم الحالي بدل العشوائي بتاع الفاكتوري
                ->state(['department_id' => $dept->id])
                ->create();
        }

        // أمثلة بأسماء محددة علامة واضحة (لو عايز شوية أسامي ثابتة)
        $fixed = [
            ['first' => 'Leader', 'last' => 'FE',   'branch' => 1],
            ['first' => 'Leader', 'last' => 'BE',   'branch' => 1],
            ['first' => 'Agent',  'last' => 'Sales','branch' => 2],
        ];

        $firstDeptId = $departments->first()?->id;

        foreach ($fixed as $fx) {
            Employee::factory()->state([
                'first_name'    => "x_({$fx['first']})",
                'last_name'     => "x_({$fx['last']})",
                'branch_id'     => $fx['branch'],
                'department_id' => $firstDeptId, // حطّهم في أول قسم كعينات
            ])->create();
        }
    }
}
