<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermitsSpatiePermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // غيّرها لو Guard مختلف
        $guard = 'web';

        $perms = [
            'permits.view',
            'permits.create',
            'permits.update',          // تعديل طلب Pending لصاحبه أو حسب السياسة
            'permits.cancel',

            'permits.approve.leader',  // اعتماد القائد
            'permits.approve.hr',      // اعتماد الـ HR

            'permits.override_rules',  // لتجاوز القواعد (ويك إند/عطلات/حدود) عند الضرورة
            'permits.review',          // لو عايز تجميعة عمومية للمراجعين
        ];

        foreach ($perms as $p) {
            Permission::firstOrCreate(
                ['name' => $p, 'guard_name' => $guard]
            );
        }

        // افتراض أسماء الأدوار – عدِّلها لمشروعك
        $roles = [
            'Admin'      => [
                'permits.view','permits.create','permits.update','permits.cancel',
                'permits.approve.leader','permits.approve.hr',
                'permits.override_rules','permits.review',
            ],
            'HR'         => [
                'permits.view','permits.create','permits.update','permits.cancel',
                'permits.approve.hr','permits.review',
            ],
            'TeamLeader' => [
                'permits.view','permits.create','permits.update','permits.cancel',
                'permits.approve.leader','permits.review',
            ],
            'TeamMember' => [
                'permits.view','permits.create','permits.update','permits.cancel',
            ],
        ];

        foreach ($roles as $roleName => $rolePerms) {
            $role = Role::firstOrCreate(
                ['name' => $roleName, 'guard_name' => $guard]
            );

            $rolePermModels = Permission::whereIn('name', $rolePerms)->get();
            $role->syncPermissions($rolePermModels->pluck('name')->all()); // idempotent
        }
    }
}
