<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        /**
         * 🔹 تعريف كل الصلاحيات الممكنة (Vacations + Permits)
         * حتى لو مش كلها مستخدمة دلوقتي
         */
        $allPermissions = [

            // === Vacations ===
            'vacations.view',
            'vacations.viewAny',
            'vacations.viewOwn',
            'vacations.create',
            'vacations.update',
            'vacations.delete',
            'vacations.reject',
            'vacations.approve', // استخدمتها في VacationPolicy كـ approve عامة

            // === Permits ===
            'permits.view',
            'permits.viewAny',
            'permits.viewOwn',
            'permits.create',
            'permits.update',
            'permits.cancel',
            'permits.reject',
            'permits.approve',        // عامة (لو محتاجتها في future)
            'permits.leaderApprove',  // قائد فريق
            'permits.hrApprove',      // HR/Admin
        ];

        // تأكد من إنشاء كل صلاحية مرة واحدة
        foreach ($allPermissions as $permName) {
            Permission::firstOrCreate(['name' => $permName]);
        }

        /**
         * 🔹 توزيع الصلاحيات حسب الدور
         */
        $rolesWithPermissions = [

            // 👤 Employee
            'Employee' => [
                'vacations.viewOwn',
                'vacations.create',
                'vacations.update',
                'vacations.delete',

                'permits.viewOwn',
                'permits.create',
                'permits.update',
                'permits.cancel',
            ],

            // 🧑‍💼 Team Lead
            'Team Lead' => [
                // Vacations
                'vacations.view',
                'vacations.viewOwn',
                'vacations.viewAny',
                'vacations.create',
                'vacations.update',
                'vacations.delete',
                'vacations.reject',
                'vacations.approve',

                // Permits
                'permits.view',
                'permits.viewOwn',
                'permits.viewAny',
                'permits.create',
                'permits.update',
                'permits.cancel',
                'permits.reject',
                'permits.leaderApprove', // قائد يعتمد أذونات
                'permits.approve',       // احتياطي لأي تحقق داخلي
            ],

            // 🧑‍💼 HR
            'HR' => [
                // Vacations
                'vacations.view',
                'vacations.viewAny',
                'vacations.reject',
                'vacations.approve',

                // Permits
                'permits.view',
                'permits.viewAny',
                'permits.reject',
                'permits.hrApprove', // اعتماد HR
                'permits.approve',   // احتياطي
            ],

            // 🛡️ Admin
            'Admin' => [
                // Vacations
                'vacations.view',
                'vacations.viewAny',
                'vacations.reject',
                'vacations.approve',

                // Permits
                'permits.view',
                'permits.viewAny',
                'permits.reject',
                'permits.hrApprove', // اعتماد HR/Admin
                'permits.approve',   // احتياطي
            ],
        ];

        /**
         * 🔹 إنشاء الأدوار وربطها بالصلاحيات
         */
        foreach ($rolesWithPermissions as $roleName => $permissions) {
            $role = Role::firstOrCreate(['name' => $roleName]);
            $role->syncPermissions($permissions);
            $this->command->info("✅ Role '{$roleName}' synced with " . count($permissions) . " permissions.");
        }

        $this->command->info('🔥 كل الصلاحيات والأدوار اتظبطت زي الفل!');
    }
}
