<?php

namespace Database\Seeders;

use App\Models\Team;
use App\Models\TeamMember;
use Illuminate\Database\Seeder;

class TeamSeeder extends Seeder
{
    public function run(): void
    {
        $am = TeamMember::inRandomOrder()->first();

        Team::firstOrCreate(
            ['name' => 'Team Alpha'],
            [
                'type' => 'squad',
                'account_manager_id' => optional($am)->id,
                'start_date' => now()->toDateString(),
                'is_active'  => true,
            ]
        );
    }
}
