<?php

namespace Database\Seeders;

use App\Models\VacationType;
use Illuminate\Database\Seeder;

class VacationTypeSeeder extends Seeder
{
    public function run(): void {
        $items = [
            ['name'=>'سنوية','code'=>'annual','required_approvals'=>2,'deducts_balance'=>true,'weekend_excluded'=>true],
            ['name'=>'مرضية','code'=>'sick','required_approvals'=>2,'deducts_balance'=>false,'weekend_excluded'=>true],
            ['name'=>'طارئة','code'=>'emergency','required_approvals'=>1,'deducts_balance'=>false,'weekend_excluded'=>true],
        ];
        foreach ($items as $i) VacationType::updateOrCreate(['code'=>$i['code']], $i);
    }
}
