<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RbacSeeder extends Seeder
{
    public function run(): void
    {
        // Permissions
        $perms = [
            'employees.view',
            'employees.create',
            'employees.update',
            'employees.delete',
            'departments.view',
            'departments.manage',
            'departments.view_members',
            'attendance.view',
            'roles.manage',
        ];

        foreach ($perms as $p) {
            Permission::firstOrCreate(['name' => $p, 'guard_name' => 'web']);
        }

        // Roles
        $admin    = Role::firstOrCreate(['name' => 'Admin',     'guard_name' => 'web']);
        $hr       = Role::firstOrCreate(['name' => 'HR',        'guard_name' => 'web']);
        $manager  = Role::firstOrCreate(['name' => 'Manager',   'guard_name' => 'web']);
        $teamLead = Role::firstOrCreate(['name' => 'Team Lead', 'guard_name' => 'web']);
        $employee = Role::firstOrCreate(['name' => 'Employee',  'guard_name' => 'web']);

        // Attach permissions
        $admin->syncPermissions(Permission::all());

        $hr->syncPermissions([
            'employees.view','employees.create','employees.update','employees.delete',
            'departments.view','attendance.view'
        ]);

        $manager->syncPermissions([
            'employees.view','employees.update', // هنقيّد التحديث بPolicy
            'departments.view','attendance.view'
        ]);

        $teamLead->syncPermissions([
            'employees.view','departments.view','departments.view_members','attendance.view'
        ]);

        $employee->syncPermissions([
            'employees.view', // هنقيّد بـ Policy إنه يشوف نفسه بس
        ]);
    }
}
