# Laravel Mail System Audit & Deliverability Report

## Executive Summary

This report provides a deep analysis of the Laravel mailing system. The system is well-architected, separating concerns effectively between controllers, services, and configuration. It securely manages per-user IMAP/SMTP credentials by encrypting them before storage. The inclusion of comprehensive diagnostic tools for both mail connectivity and DNS health is a significant strength, demonstrating a proactive approach to deliverability.

However, several areas can be improved. The SMTP sending logic lacks explicit envelope sender configuration, creating a potential for SPF/DMARC alignment failures. The IMAP implementation could be optimized for performance with larger mailboxes, and error handling could be more robust. Security can be tightened by explicitly validating folder names and attachment paths to prevent path traversal vulnerabilities.

The following report details these findings and provides a concrete action plan for remediation and improvement.

## Action Plan (1-2 Week Roadmap)

**High Priority (Week 1):**
1.  **Fix SMTP Envelope Sender:** Modify the SMTP sending logic in `EmailService` to explicitly set the `Envelope-From` (`returnPath`) to match the user's authenticated SMTP username. This is critical for DMARC alignment.
2.  **Strengthen Security:** Implement strict validation for all user inputs, especially the `folder` parameter in `EmailController` and the attachment index, to prevent directory traversal attacks.
3.  **Add Missing SMTP Columns:** Create a new migration to add `smtp_host`, `smtp_port`, `smtp_encryption`, `smtp_username`, and `smtp_password_encrypted` columns to the `users` table to properly store per-user SMTP settings.
4.  **Improve Error Handling:** Wrap IMAP/SMTP operations in `try...catch` blocks within the `EmailController` and provide user-friendly feedback on the UI instead of letting exceptions crash the request.

**Medium Priority (Week 2):**
1.  **Refactor Credential Handling:** Update `MailboxController` and `EmailService` to use the new dedicated SMTP columns.
2.  **Implement Queued Sending:** Refactor the `send` method in `EmailService` to use a queued job for sending emails. This will improve UI responsiveness and add resilience.
3.  **Optimize IMAP Queries:** Implement server-side pagination and caching for IMAP folder lists and message headers to improve performance on large mailboxes.
4.  **Enhance DNS Health Tool:** Improve the SPF check to handle `include` recursion and support multiple DKIM selectors.

---

## 1. Architecture Overview

The mailing system follows a classic Service-Controller pattern. User requests are handled by controllers, which delegate the core business logic to dedicated service classes.

**Mail Flow Diagram (Mermaid):**
```mermaid
sequenceDiagram
    participant User
    participant Routes
    participant Controllers
    participant Services
    participant Mail Servers

    User->>Routes: HTTP Request (e.g., GET /email/inbox)
    Routes->>Controllers: Dispatch to Controller@method
    Controllers->>Services: Call Service (e.g., EmailService->getInbox())
    Services->>Mail Servers: IMAP/SMTP Communication
    Mail Servers-->>Services: Response (Messages/Status)
    Services-->>Controllers: Return Data
    Controllers-->>User: Render View / JSON Response
```

**Key Components:**
*   **Controllers:** `EmailController`, `MailboxController`, `MailHealthController`, `DnsHealthController`. They handle HTTP requests, input validation, and user authentication.
*   **Services:** `EmailService`, `MailDiagnostics`, `DnsHealthService`. They contain the core logic for interacting with mail servers and performing diagnostics.
*   **Routes:** Defined in `routes/web.php`, they map URLs to controller actions.
*   **Configuration:** `config/mail.php` (SMTP), `config/imap.php` (IMAP).
*   **Helpers:** `App\Support\Sec` for credential encryption.
*   **Views:** Blade templates in `resources/views/email/` for the UI.

## 2. Source Map

| Path                                                              | Role & Key Methods                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          - **Controllers**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             - `app/Http/Controllers/EmailController.php`                               | **Role:** Handles all user-facing email actions (inbox, detail, send, etc.).<br>**Methods:** `inbox`, `detail`, `attachment`, `markRead`, `markUnread`, `compose`, `send`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          - `app/Http/Controllers/MailboxController.php`                             | **Role:** Manages connecting/disconnecting user mailboxes.<br>**Methods:** `store` (encrypts and saves credentials), `destroy` (removes credentials).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  - `app/Http/Controllers/MailHealthController.php`                          | **Role:** Displays the mail connectivity diagnostic page.<br>**Methods:** `index` (runs checks via `MailDiagnostics` service).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              - `app/Http/Controllers/DnsHealthController.php`                           | **Role:** Displays the DNS health diagnostic page.<br>**Methods:** `index` (runs checks via `DnsHealthService`).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                - **Services**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                - `app/Services/EmailService.php`                                            | **Role:** Core logic for IMAP/SMTP. Manages the IMAP client, fetches/sends messages, handles attachments.<br>**Methods:** `connect`, `getFolders`, `getMessages`, `getMessage`, `send`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               - `app/Services/MailDiagnostics.php`                                       | **Role:** Logic for the Mail Health page.<br>**Methods:** `getEnvSnapshot`, `checkDnsResolution`, `checkTcpConnection`, `checkImapLogin`, `checkSmtp`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 - `app/Services/DnsHealthService.php`                                        | **Role:** Logic for the DNS Health page.<br>**Methods:** `getRecords`, `analyzeDns`, `hasValidSpf`, `hasValidDkim`, `hasValidDmarc`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      - **Helpers**                                                                                                                                                            - `app/Support/Sec.php`                                                      | **Role:** Encrypts and decrypts credentials.<br>**Methods:** `enc`, `dec`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     - **Views**                                                                                                                                                              - `resources/views/email/inbox.blade.php`                                    | **Role:** Main inbox view, lists messages.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             - `resources/views/email/detail.blade.php`                                   | **Role:** Displays a single email, including headers, body, and attachments.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              - `resources/views/email/compose.blade.php`                                  | **Role:** Provides the form for composing and sending a new email.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       - `resources/views/email/connect.blade.php`                                  | **Role:** Form for users to input their IMAP/SMTP credentials.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    - **Configs**                                                                                                                                                            - `config/mail.php`                                                          | **Role:** Laravel's primary mail configuration. Defines mailers (transports) and global `From` address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             - `config/imap.php`                                                          | **Role:** Webklex PHP-IMAP configuration. Sets default connection parameters, fetch options, and folder names.                                                                                                                                                           - **Routes**                                                                                                                                                             - `routes/web.php`                                                           | **Role:** Defines all web-facing routes, including `email.*`, `mailbox.*`, and `email.tools.*`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                - **Migrations**                                                                                                                                                         - `...add_imap_columns_to_users_table.php`                                   | **Role:** Adds `imap_username` and `imap_password_encrypted` to the `users` table. **Note:** SMTP columns are missing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     -

## 3. IMAP (Receiving)

-   **Client Construction:** The `EmailService` dynamically constructs the IMAP client using `Webklex\PHPIMAP\ClientManager`. It creates a configuration array on the fly, overriding the defaults from `config/imap.php` with the user's decrypted credentials from the database.
-   **Connection Logic:** Connection is established lazily when an action requires it (e.g., fetching folders). The timeout is configured in `config/imap.php` (`timeout => 30`). Error handling is minimal at the controller level, with exceptions likely causing a crash.
-   **Webklex Nuances:**
    *   **Dates:** The code correctly handles `Carbon` objects returned by `getDate()`.
    *   **Flags:** The system uses `hasFlag('Seen')` to check the read status of messages, which is the correct approach.
-   **Queries:** The `EmailService` fetches messages for a given folder, applies pagination, and can leave messages unread using `leaveUnread()`. Search functionality is also implemented.
-   **Attachments:** Attachments are enumerated from the message object and streamed directly to the browser via the `EmailController@attachment` method, which is memory-efficient.

## 4. SMTP (Sending)

-   **DSN Building:** The system uses Laravel's default mailer configuration. The DSN is built implicitly by Laravel based on the `.env` variables (`MAIL_HOST`, `MAIL_PORT`, `MAIL_ENCRYPTION`). For per-user SMTP, the `EmailService` dynamically creates a new mailer instance with the user's credentials.
-   **Alignment & Envelope:**
    *   **CRITICAL ISSUE:** The system does **not** explicitly set the envelope sender (`Return-Path`). The `EmailService` sets the `From` header, but Symfony Mailer may default to the `.env` `MAIL_FROM_ADDRESS` for the envelope, causing a mismatch with the user's `From` address and leading to SPF/DMARC alignment failures.
    *   **Recommendation:** The `send` method in `EmailService` must be updated to use a `Symfony\Component\Mime\Email` object and set the `returnPath()` to the user's SMTP username.
-   **Headers:** A debug header `X-App-Mail-Debug` is not found in the codebase. This would be a valuable addition for tracing emails.
-   **Attachments & Alternatives:** The system handles attachments correctly. Plain-text alternative generation is handled automatically by Laravel's Mailable system.

## 5. Credentials & Security

-   **Credential Storage:** User credentials (`imap_username`, `imap_password_encrypted`) are stored in the `users` table. The password is encrypted using Laravel's `Crypt` facade via the `App\Support\Sec` helper. **Note:** There are no columns for per-user SMTP credentials.
-   **Secret Leakage:** The `Sec::dec` helper correctly catches `DecryptException` and reports it without logging the encrypted payload, preventing secret leakage in logs.
-   **HTML Sanitization:** The use of `mews/purifier` was specified, but no explicit usage is found in the analyzed files. This is a **critical vulnerability**. Message bodies must be sanitized before being rendered in the `email/detail.blade.php` view to prevent XSS attacks.
-   **Input Validation:** Basic validation is likely handled by Laravel's form requests, but there is no explicit validation on URL parameters like `uid` or `folder`. This could allow for manipulation or path traversal attacks.

## 6. UI/UX Views

-   **`inbox.blade.php`:** Renders the list of messages, including sender, subject, and date.
-   **`detail.blade.php`:** Displays the full email content. It should include an iframe for sandboxed HTML rendering.
-   **`compose.blade.php`:** The form for writing new emails.
-   **`partials/mini-inbox.blade.php`:** A compact inbox view, likely used in a dashboard sidebar.
-   **State Preservation:** The application appears to handle pagination state (`sp`/`sl`) and folder selection in URLs, allowing for bookmarkable links.

## 7. Routes & Endpoints

| Method | URI                               | Name                     | Action                                     | Middleware |
| :--- | :-------------------------------- | :----------------------- | :----------------------------------------- | :--- |
| GET    | `/email/inbox`                    | `email.inbox`            | `EmailController@inbox`                    | `auth`     |
| GET    | `/email/detail/{uid}`             | `email.detail`           | `EmailController@detail`                   | `auth`     |
| GET    | `/email/attachment/{uid}/{index?}`| `email.attachment`       | `EmailController@attachment`               | `auth`     |
| POST   | `/email/mark-read`                | `email.markRead`         | `EmailController@markRead`                 | `auth`     |
| POST   | `/email/mark-unread`              | `email.markUnread`       | `EmailController@markUnread`               | `auth`     |
| GET    | `/email/folders`                  | `email.folders`          | `EmailController@folders`                  | `auth`     |
| GET    | `/email/search`                   | `email.search`           | `EmailController@search`                   | `auth`     |
| GET    | `/email/compose`                  | `email.compose`          | `EmailController@compose`                  | `auth`     |
| POST   | `/email/send`                     | `email.send`             | `EmailController@send`                     | `auth`     |
| GET    | `/mailbox/connect`                | `mailbox.connect.view`   | `View: email.connect`                      | `auth`     |
| POST   | `/mailbox/connect`                | `mailbox.connect`        | `MailboxController@store`                  | `auth`     |
| DELETE | `/mailbox`                        | `mailbox.disconnect`     | `MailboxController@destroy`                | `auth`     |
| GET    | `/mailbox/status`                 | `mailbox.status`         | `MailboxController@status`                 | `auth`     |
| GET    | `/email/tools/health`             | `email.tools.health`     | `MailHealthController@index`               | `auth`     |
| GET    | `/email/tools/dns`                | `email.tools.dns`        | `DnsHealthController@index`                | `auth`     |

## 8. Diagnostics Pages

-   **Mail Health (`/email/tools/health`):**
    *   **Checks:** ENV Snapshot, DNS Resolution, TCP Port Test, IMAP Login, SMTP Start.
    *   **Implementation:** The `MailDiagnostics` service performs these checks using a combination of `env()`, `gethostbyname()`, `fsockopen()`, and the `EmailService` itself.
    *   **UI:** The `mail-health.blade.php` view renders a checklist with PASS/FAIL status and detailed output for each check.
-   **DNS Health (`/email/tools/dns`):**
    *   **Checks:** A/AAAA, PTR, MX, SPF, DKIM (`default._domainkey`), DMARC.
    *   **Implementation:** The `DnsHealthService` uses PHP's `dns_get_record()` function. It includes logic to parse and validate SPF and DMARC records.
    *   **Improvements:** The SPF check is basic and does not recursively resolve `include` mechanisms. The DKIM check only looks for the `default` selector.

## 9. Deliverability Guidance

1.  **DMARC:** Ensure a DMARC record exists and is configured with at least `p=none`. A `rua` tag is highly recommended for reporting.
2.  **SPF:** The SPF record must authorize the IP address of the sending server. If using a third-party service, it must be included via an `include:` mechanism.
3.  **DKIM:** The `default._domainkey` CNAME or TXT record must be correctly published in the DNS.
4.  **PTR Record:** The server's IP address should have a PTR record that resolves back to the sending hostname (e.g., `mail.yourdomain.com`).
5.  **Cloudflare:** If using Cloudflare, the `MX` records and the hostname used for mail (`mail.yourdomain.com`) must be set to "DNS Only" (grey-clouded).

## 10. Quality, Performance & Error Handling

-   **Timeouts:** IMAP and SMTP timeouts are handled reasonably well at the service level.
-   **Pagination:** The current implementation fetches all message headers from the IMAP server and then paginates the collection in PHP. This will be slow for mailboxes with thousands of messages. Server-side pagination (`$folder->query()->paginate()`) should be used instead.
-   **Attachment Streaming:** Attachments are streamed directly, which is excellent for memory management.
-   **Error Handling:** Controllers lack `try...catch` blocks around service calls, meaning that any exception from the `EmailService` (e.g., connection timeout, invalid credentials) will result in a 500 error page. This should be improved to provide a better user experience.

## 11. Security Review

-   **Hard-coded Credentials:** None found. Credentials are encrypted and stored per-user.
-   **CSRF:** All POST routes are correctly protected by Laravel's default CSRF middleware.
-   **Input Validation:** **MAJOR WEAKNESS.** There is no apparent validation of folder names or attachment paths. A malicious user could potentially craft a request with `folder=../../...` to access unintended parts of the filesystem. All user-provided path components must be strictly validated.
-   **Secret Exposure:** No secrets are exposed in Blade templates or JSON responses.

## 12. Configuration Matrix

| Key                         | File            | Default               | Example                               | Purpose                                     |
| :-------------------------- | :-------------- | :-------------------- | :------------------------------------ | :------------------------------------------ |
| `MAIL_MAILER`               | `.env`          | `smtp`                | `smtp`                                | Default Laravel mailer                      |
| `MAIL_HOST`                 | `.env`          | `localhost`           | `smtp.mailgun.org`                    | SMTP server host                            |
| `MAIL_PORT`                 | `.env`          | `1025`                | `587`                                 | SMTP server port                            |
| `MAIL_ENCRYPTION`           | `.env`          | `tls`                 | `tls`                                 | SMTP encryption protocol                    |
| `MAIL_FROM_ADDRESS`         | `.env`          | `hello@example.com`   | `noreply@yourdomain.com`              | Global `From` email address                 |
| `IMAP_HOST`                 | `.env`          | `localhost`           | `imap.gmail.com`                      | IMAP server host                            |
| `IMAP_PORT`                 | `.env`          | `993`                 | `993`                                 | IMAP server port                            |
| `IMAP_ENCRYPTION`           | `.env`          | `ssl`                 | `ssl`                                 | IMAP encryption protocol                    |
| `IMAP_VALIDATE_CERT`        | `.env`          | `true`                | `true`                                | Validate SSL certificate                    |
| `imap_username`             | `users` table   | `NULL`                | `user@domain.com`                     | Per-user IMAP username                      |
| `imap_password_encrypted`   | `users` table   | `NULL`                | (Encrypted)                           | Per-user encrypted IMAP password            |

## 13. How to Run / Test

**`.env` Snippet:**
```ini
MAIL_MAILER=smtp
MAIL_HOST=your_smtp_host
MAIL_PORT=587
MAIL_ENCRYPTION=tls
MAIL_USERNAME=your_smtp_username
MAIL_PASSWORD=your_smtp_password
MAIL_FROM_ADDRESS=your_from_address@domain.com
MAIL_FROM_NAME="Your Name"

IMAP_HOST=your_imap_host
IMAP_PORT=993
IMAP_ENCRYPTION=ssl
IMAP_VALIDATE_CERT=true
```

**cURL Examples:**
```bash
# Mark a message as read (replace UID and CSRF token)
curl -X POST -H "X-CSRF-TOKEN: <token>" -d "uid=<message_uid>" https://your-app.com/email/mark-read

# Send an email (replace CSRF token and form data)
curl -X POST -H "X-CSRF-TOKEN: <token>" -d "to=recipient@example.com&subject=Test&body=Hello" https://your-app.com/email/send
```

**Tinker Snippets:**
```php
// List inbox for user with ID 1
$user = App\Models\User::find(1);
$service = new App\Services\EmailService($user);
$messages = $service->getMessages('INBOX');
echo $messages->count();

// Send a test email
Mail::raw('This is a test', fn($msg) => $msg->to('test@example.com')->subject('Test Email'));
```

## 14. Issues & TODOs

-   **Critical Bug:** The SMTP `Envelope-From` is not being set, which will cause DMARC failures for most modern mail providers.
-   **Critical Vulnerability:** Lack of HTML sanitization on the email detail page exposes the application to XSS attacks.
-   **Vulnerability:** Lack of validation on folder and attachment paths could lead to directory traversal.
-   **Missing Feature:** The system does not store per-user SMTP credentials, forcing all users to send from the system's default mailer.
-   **Performance:** IMAP message fetching will be slow on large mailboxes.
-   **Refactor:** Sending email should be moved to a background queue to improve user experience.
-   **Refactor:** Error handling in controllers should be improved to catch exceptions from services and display friendly errors.
