# Configuration Report

## 1. Environment Variables (.env)

These are the environment variables that control the mailing system. Values are masked for security.

```
# IMAP Connection Settings
IMAP_HOST=your_imap_host
IMAP_PORT=993
IMAP_ENCRYPTION=ssl
IMAP_VALIDATE_CERT=true
IMAP_USERNAME=your_imap_username
IMAP_PASSWORD=********
IMAP_DEFAULT_ACCOUNT=default

# Mail Sending Settings
MAIL_MAILER=smtp
MAIL_HOST=your_smtp_host
MAIL_PORT=587
MAIL_USERNAME=your_smtp_username
MAIL_PASSWORD=********
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@example.com
MAIL_FROM_NAME="Your App Name"

# Queue Settings (if used for mail)
QUEUE_CONNECTION=sync
```

## 2. IMAP Configuration (config/imap.php)

The effective IMAP settings are a combination of the `.env` variables and the defaults in this file.

- **Default Account**: `default`
- **Default Fetch Protocol**: `IMAP::FT_PEEK` (Does not mark messages as read on fetch).
- **Default Sequence**: `IMAP::ST_UID` (Uses UID for message identification).
- **Hardcoded Account**: A critical issue exists where an account named `cpanel` is hardcoded with credentials directly in the configuration file. This should be removed immediately.

```php
// Hardcoded credentials found in config/imap.php - THIS IS A MAJOR SECURITY RISK
'cpanel' => [
    'host'          => 'mail.mediafactoryworld.com',
    'port'          => 993,
    'encryption'    => 'ssl',
    'validate_cert' => true,
    'username'      => 'jemy_test@mediafactoryworld.com',
    'password'      => 'LPBR[@1~?dV+', // <-- SECRET VALUE
    'protocol'      => 'imap'
],
```

## 3. Mail Configuration (config/mail.php)

- **Default Mailer**: `smtp` (as controlled by `MAIL_MAILER` in `.env`).
- **From Address**: The global from address is controlled by `MAIL_FROM_ADDRESS` and `MAIL_FROM_NAME`.
- **Other Mailers**: `ses`, `mailgun`, `postmark`, `log`, and `array` mailers are configured but not currently used.

## 4. Composer Dependencies

- **`webklex/laravel-imap`**: `^4.1`
- **`laravel/framework`**: `^10.0`
- **`php`**: `^8.1`

## 5. User-Specific Account Switching

- **IMAP (Receiving)**: There is no mechanism for user-specific IMAP accounts. The system uses a single, hardcoded global account, despite the appearance of dynamic user code in `EmailService`.
- **SMTP (Sending)**: The system correctly uses the authenticated user's `email` and `email_password` from the `users` table to send mail. The password is decrypted just before sending.
