# Data Model

## 1. Current Database Schema

There are **no dedicated tables** for caching or storing email messages, attachments, or mailboxes. The only relevant schema modification is in the `users` table.

### `users` Table Modification

A migration adds the `email_password` column to the `users` table to store individual user credentials for sending mail (SMTP).

- `email_password` (string, nullable): Stores the encrypted SMTP password for the user.

## 2. Proposed Caching Schema

To improve performance and reduce reliance on live IMAP calls, a caching mechanism is recommended. The following schema could be implemented to store copies of messages and their attachments.

### Mermaid ERD

```mermaid
erDiagram
    USERS {
        int id PK
        string name
        string email
        string email_password
    }

    CACHED_EMAILS {
        int id PK
        int user_id FK
        string folder
        bigint uid UK
        string message_id UK
        string from_address
        text to_address
        text cc_address
        text bcc_address
        string subject
        datetime date
        text flags
        boolean has_attachments
        text snippet
        string body_hash
        datetime seen_at
        datetime fetched_at
        int size_bytes
    }

    CACHED_ATTACHMENTS {
        int id PK
        int cached_email_id FK
        string name
        string content_id
        string content_type
        int size_bytes
        string stored_path
    }

    USERS ||--o{ CACHED_EMAILS : has
    CACHED_EMAILS ||--o{ CACHED_ATTACHMENTS : has
```

### Table Fields

#### `cached_emails`

- **id**: Primary key.
- **user_id**: Foreign key to `users.id` to associate the email with a user account.
- **folder**: The IMAP folder the message belongs to (e.g., 'INBOX', 'Sent').
- **uid**: The message UID from the IMAP server. This, combined with `user_id` and `folder`, should be unique.
- **message_id**: The `Message-ID` header value.
- **from_address, to_address, cc_address, bcc_address**: Sender and recipient addresses.
- **subject**: The email subject.
- **date**: The email date.
- **flags**: A JSON or comma-separated list of IMAP flags (e.g., `[\\Seen, \\Flagged]`).
- **has_attachments**: A boolean flag for quick identification of emails with attachments.
- **snippet**: A short, plain-text preview of the email body.
- **body_hash**: A hash of the email body to detect changes.
- **seen_at**: Timestamp of when the email was first marked as read.
- **fetched_at**: Timestamp of when the record was last synced with the IMAP server.
- **size_bytes**: The size of the message in bytes.
- **mime_summary**: A summary of the MIME parts for advanced parsing.

#### `cached_attachments`

- **id**: Primary key.
- **cached_email_id**: Foreign key to `cached_emails.id`.
- **name**: The attachment's filename.
- **content_id**: The attachment's Content-ID, if available.
- **content_type**: The MIME type of the attachment.
- **size_bytes**: The size of the attachment in bytes.
- **stored_path**: The path to the attachment stored on the local filesystem or cloud storage.

## 3. Caching Strategy: When to Cache vs. Live Access

- **Live Access**: Best for actions that require immediate confirmation from the server, such as setting flags (`\\Seen`, `\\Deleted`) or moving messages. The initial fetch of a folder might also be live to get the most recent list of UIDs.
- **Cache**: Best for reading message content (headers, body, attachments). Once a message is fetched, its content can be stored in the database. Subsequent views of the same message should read from the cache.
- **Hybrid Approach**: A common strategy is to fetch the list of message UIDs from the server and then check the cache for which of those UIDs are already stored. Only new or changed messages would be fully downloaded and cached. A background job could periodically sync folders to keep the cache fresh.

```