export default {
  data: {
    gdp: {
      name: 'GDP per capita',
      format: '{0} USD',
      thousandSeparator: ','
    },
    change: {
      name: 'Change to year before',
      format: '{0} %'
    },
    gdpAdjusted: {
      name: 'Purchasing Power Parity',
      format: '{0} USD',
      thousandSeparator: ',',
      thresholdMax: 60000,
      thresholdMin: 1000
    },
    changeAdjusted: {
      name: 'Change to year before',
      format: '{0} %'
    }
  },
  applyData: 'gdpAdjusted',
  values: {
    AF: {
      link: 'https://pt.wikipedia.org/wiki/AF',
      linkTarget: '_blank',
      gdp: 587,
      change: 4.73,
      linkTarget: '_blank',
      gdpAdjusted: 1958,
      changeAdjusted: 0.02
    },
    AL: {
      link: 'https://pt.wikipedia.org/wiki/AL',
      linkTarget: '_blank',
      gdp: 4583,
      change: 11.09,
      linkTarget: '_blank',
      gdpAdjusted: 12507,
      changeAdjusted: 4.04
    },
    DZ: {
      link: 'https://pt.wikipedia.org/wiki/DZ',
      linkTarget: '_blank',
      gdp: 4293,
      change: 10.01,
      linkTarget: '_blank',
      gdpAdjusted: 15237,
      changeAdjusted: 0.33
    },
    AO: {
      link: 'https://pt.wikipedia.org/wiki/AO',
      linkTarget: '_blank',
      gdp: 4408,
      change: 26.49,
      linkTarget: '_blank',
      gdpAdjusted: 6753,
      changeAdjusted: -2.56
    },
    AG: {
      link: 'https://pt.wikipedia.org/wiki/AG',
      linkTarget: '_blank',
      gdp: 16702,
      change: 3.26,
      linkTarget: '_blank',
      gdpAdjusted: 26231,
      changeAdjusted: 2.15
    },
    AR: {
      link: 'https://pt.wikipedia.org/wiki/AR',
      linkTarget: '_blank',
      gdp: 14467,
      change: 13.83,
      linkTarget: '_blank',
      gdpAdjusted: 20876,
      changeAdjusted: 1.77
    },
    AM: {
      link: 'https://pt.wikipedia.org/wiki/AM',
      linkTarget: '_blank',
      gdp: 3861,
      change: 9.22,
      linkTarget: '_blank',
      gdpAdjusted: 9456,
      changeAdjusted: 7.33
    },
    AU: {
      link: 'https://pt.wikipedia.org/wiki/AU',
      linkTarget: '_blank',
      gdp: 55707,
      change: 7.39,
      linkTarget: '_blank',
      gdpAdjusted: 50334,
      changeAdjusted: 0.97
    },
    AT: {
      link: 'https://pt.wikipedia.org/wiki/AT',
      linkTarget: '_blank',
      gdp: 47290,
      change: 5.72,
      linkTarget: '_blank',
      gdpAdjusted: 49869,
      changeAdjusted: 2.66
    },
    AZ: {
      link: 'https://pt.wikipedia.org/wiki/AZ',
      linkTarget: '_blank',
      gdp: 4141,
      change: 6.29,
      linkTarget: '_blank',
      gdpAdjusted: 17492,
      changeAdjusted: -0.91
    },
    BS: {
      link: 'https://pt.wikipedia.org/wiki/BS',
      linkTarget: '_blank',
      gdp: 31255,
      change: 2.21,
      linkTarget: '_blank',
      gdpAdjusted: 31139,
      changeAdjusted: 0.31
    },
    BH: {
      link: 'https://pt.wikipedia.org/wiki/BH',
      linkTarget: '_blank',
      gdp: 24029,
      change: 6.32,
      linkTarget: '_blank',
      gdpAdjusted: 48505,
      changeAdjusted: 1.02
    },
    BD: {
      link: 'https://pt.wikipedia.org/wiki/BD',
      linkTarget: '_blank',
      gdp: 1602,
      change: 9.79,
      linkTarget: '_blank',
      gdpAdjusted: 4211,
      changeAdjusted: 6.1
    },
    BB: {
      link: 'https://pt.wikipedia.org/wiki/BB',
      linkTarget: '_blank',
      gdp: 17859,
      change: 7.83,
      linkTarget: '_blank',
      gdpAdjusted: 18664,
      changeAdjusted: 0.64
    },
    BY: {
      link: 'https://pt.wikipedia.org/wiki/BY',
      linkTarget: '_blank',
      gdp: 5760,
      change: 14.69,
      linkTarget: '_blank',
      gdpAdjusted: 18931,
      changeAdjusted: 2.52
    },
    BE: {
      link: 'https://pt.wikipedia.org/wiki/BE',
      linkTarget: '_blank',
      gdp: 43582,
      change: 5.3,
      linkTarget: '_blank',
      gdpAdjusted: 46553,
      changeAdjusted: 1.13
    },
    BZ: {
      link: 'https://pt.wikipedia.org/wiki/BZ',
      linkTarget: '_blank',
      gdp: 4806,
      change: -0.64,
      linkTarget: '_blank',
      gdpAdjusted: 8324,
      changeAdjusted: -1.35
    },
    BJ: {
      link: 'https://pt.wikipedia.org/wiki/BJ',
      linkTarget: '_blank',
      gdp: 830,
      change: 4.92,
      linkTarget: '_blank',
      gdpAdjusted: 2277,
      changeAdjusted: 3.46
    },
    BT: {
      link: 'https://pt.wikipedia.org/wiki/BT',
      linkTarget: '_blank',
      gdp: 2903,
      change: 8.01,
      linkTarget: '_blank',
      gdpAdjusted: 8744,
      changeAdjusted: 4.82
    },
    BO: {
      link: 'https://pt.wikipedia.org/wiki/BO',
      linkTarget: '_blank',
      gdp: 3353,
      change: 7.3,
      linkTarget: '_blank',
      gdpAdjusted: 7547,
      changeAdjusted: 2.73
    },
    BA: {
      link: 'https://pt.wikipedia.org/wiki/BA',
      linkTarget: '_blank',
      gdp: 5149,
      change: 7.04,
      linkTarget: '_blank',
      gdpAdjusted: 12724,
      changeAdjusted: 2.6
    },
    BW: {
      link: 'https://pt.wikipedia.org/wiki/BW',
      linkTarget: '_blank',
      gdp: 7877,
      change: 8.34,
      linkTarget: '_blank',
      gdpAdjusted: 17828,
      changeAdjusted: 0.38
    },
    BR: {
      link: 'https://pt.wikipedia.org/wiki/BR',
      linkTarget: '_blank',
      gdp: 9895,
      change: 13.74,
      linkTarget: '_blank',
      gdpAdjusted: 15602,
      changeAdjusted: 0.23
    },
    BN: {
      link: 'https://pt.wikipedia.org/wiki/BN',
      linkTarget: '_blank',
      gdp: 29712,
      change: 10.31,
      linkTarget: '_blank',
      gdpAdjusted: 78196,
      changeAdjusted: -0.7
    },
    BG: {
      link: 'https://pt.wikipedia.org/wiki/BG',
      linkTarget: '_blank',
      gdp: 8064,
      change: 7.58,
      linkTarget: '_blank',
      gdpAdjusted: 21687,
      changeAdjusted: 4.23
    },
    BF: {
      link: 'https://pt.wikipedia.org/wiki/BF',
      linkTarget: '_blank',
      gdp: 664,
      change: 8.11,
      linkTarget: '_blank',
      gdpAdjusted: 1889,
      changeAdjusted: 3.55
    },
    BI: {
      link: 'https://pt.wikipedia.org/wiki/BI',
      linkTarget: '_blank',
      gdp: 312,
      change: 4.85,
      linkTarget: '_blank',
      gdpAdjusted: 735,
      changeAdjusted: -5.2
    },
    KH: {
      link: 'https://pt.wikipedia.org/wiki/KH',
      linkTarget: '_blank',
      gdp: 1389,
      change: 8.76,
      linkTarget: '_blank',
      gdpAdjusted: 4012,
      changeAdjusted: 5.46
    },
    CM: {
      link: 'https://pt.wikipedia.org/wiki/CM',
      linkTarget: '_blank',
      gdp: 1401,
      change: 2.94,
      linkTarget: '_blank',
      gdpAdjusted: 3660,
      changeAdjusted: 0.62
    },
    CA: {
      link: 'https://pt.wikipedia.org/wiki/CA',
      linkTarget: '_blank',
      gdp: 45077,
      change: 6.27,
      linkTarget: '_blank',
      gdpAdjusted: 48265,
      changeAdjusted: 2.1
    },
    XK: {
      link: 'https://pt.wikipedia.org/wiki/XK',
      linkTarget: '_blank',
      gdp: 3880,
      change: 6.23,
      linkTarget: '_blank',
      gdpAdjusted: 10514,
      changeAdjusted: 3.14
    },
    CV: {
      link: 'https://pt.wikipedia.org/wiki/CV',
      linkTarget: '_blank',
      gdp: 3237,
      change: 4.91,
      linkTarget: '_blank',
      gdpAdjusted: 6944,
      changeAdjusted: 2.69
    },
    CF: {
      link: 'https://pt.wikipedia.org/wiki/CF',
      linkTarget: '_blank',
      gdp: 387,
      change: 7.65,
      linkTarget: '_blank',
      gdpAdjusted: 677,
      changeAdjusted: 2.45
    },
    TD: {
      link: 'https://pt.wikipedia.org/wiki/TD',
      linkTarget: '_blank',
      gdp: 810,
      change: -0.71,
      linkTarget: '_blank',
      gdpAdjusted: 2344,
      changeAdjusted: -6.15
    },
    CL: {
      link: 'https://pt.wikipedia.org/wiki/CL',
      linkTarget: '_blank',
      gdp: 15070,
      change: 9.66,
      linkTarget: '_blank',
      gdpAdjusted: 24537,
      changeAdjusted: 0.69
    },
    CN: {
      link: 'https://pt.wikipedia.org/wiki/CN',
      linkTarget: '_blank',
      gdp: 8643,
      change: 6.5,
      linkTarget: '_blank',
      gdpAdjusted: 16660,
      changeAdjusted: 6.47
    },
    CO: {
      link: 'https://pt.wikipedia.org/wiki/CO',
      linkTarget: '_blank',
      gdp: 6273,
      change: 9.21,
      linkTarget: '_blank',
      gdpAdjusted: 14485,
      changeAdjusted: 0.96
    },
    KM: {
      link: 'https://pt.wikipedia.org/wiki/KM',
      linkTarget: '_blank',
      gdp: 788,
      change: 3.09,
      linkTarget: '_blank',
      gdpAdjusted: 1588,
      changeAdjusted: 0.25
    },
    CG: {
      link: 'https://pt.wikipedia.org/wiki/CG',
      linkTarget: '_blank',
      gdp: 1958,
      change: 6.66,
      linkTarget: '_blank',
      gdpAdjusted: 6642,
      changeAdjusted: -7.2
    },
    CR: {
      link: 'https://pt.wikipedia.org/wiki/CR',
      linkTarget: '_blank',
      gdp: 11685,
      change: -0.77,
      linkTarget: '_blank',
      gdpAdjusted: 16877,
      changeAdjusted: 2.24
    },
    HR: {
      link: 'https://pt.wikipedia.org/wiki/HR',
      linkTarget: '_blank',
      gdp: 13138,
      change: 6.7,
      linkTarget: '_blank',
      gdpAdjusted: 24423,
      changeAdjusted: 3.15
    },
    CY: {
      link: 'https://pt.wikipedia.org/wiki/CY',
      linkTarget: '_blank',
      gdp: 24976,
      change: 5.65,
      linkTarget: '_blank',
      gdpAdjusted: 37023,
      changeAdjusted: 3.95
    },
    CZ: {
      link: 'https://pt.wikipedia.org/wiki/CZ',
      linkTarget: '_blank',
      gdp: 20152,
      change: 8.9,
      linkTarget: '_blank',
      gdpAdjusted: 35512,
      changeAdjusted: 4.23
    },
    CD: {
      link: 'https://pt.wikipedia.org/wiki/CD',
      linkTarget: '_blank',
      gdp: 478,
      change: 2.32,
      linkTarget: '_blank',
      gdpAdjusted: 790,
      changeAdjusted: 0.2
    },
    DK: {
      link: 'https://pt.wikipedia.org/wiki/DK',
      linkTarget: '_blank',
      gdp: 56444,
      change: 4.97,
      linkTarget: '_blank',
      gdpAdjusted: 49883,
      changeAdjusted: 1.49
    },
    DJ: {
      link: 'https://pt.wikipedia.org/wiki/DJ',
      linkTarget: '_blank',
      gdp: 1989,
      change: 4.52,
      linkTarget: '_blank',
      gdpAdjusted: 3559,
      changeAdjusted: 5.19
    },
    DM: {
      link: 'https://pt.wikipedia.org/wiki/DM',
      linkTarget: '_blank',
      gdp: 7921,
      change: -3.63,
      linkTarget: '_blank',
      gdpAdjusted: 11102,
      changeAdjusted: -4.69
    },
    DO: {
      link: 'https://pt.wikipedia.org/wiki/DO',
      linkTarget: '_blank',
      gdp: 7375,
      change: 3.67,
      linkTarget: '_blank',
      gdpAdjusted: 16944,
      changeAdjusted: 3.5
    },
    EC: {
      link: 'https://pt.wikipedia.org/wiki/EC',
      linkTarget: '_blank',
      gdp: 6098,
      change: 2.21,
      linkTarget: '_blank',
      gdpAdjusted: 11482,
      changeAdjusted: 1.29
    },
    EG: {
      link: 'https://pt.wikipedia.org/wiki/EG',
      linkTarget: '_blank',
      gdp: 2501,
      change: -32.17,
      linkTarget: '_blank',
      gdpAdjusted: 12671,
      changeAdjusted: 2.36
    },
    SV: {
      link: 'https://pt.wikipedia.org/wiki/SV',
      linkTarget: '_blank',
      gdp: 4400,
      change: 4.06,
      linkTarget: '_blank',
      gdpAdjusted: 8948,
      changeAdjusted: 1.88
    },
    GQ: {
      link: 'https://pt.wikipedia.org/wiki/GQ',
      linkTarget: '_blank',
      gdp: 12727,
      change: 2.65,
      linkTarget: '_blank',
      gdpAdjusted: 36017,
      changeAdjusted: -7.97
    },
    ER: {
      link: 'https://pt.wikipedia.org/wiki/ER',
      linkTarget: '_blank',
      gdp: 980,
      change: 13.88,
      linkTarget: '_blank',
      gdpAdjusted: 1581,
      changeAdjusted: 2.73
    },
    EE: {
      link: 'https://pt.wikipedia.org/wiki/EE',
      linkTarget: '_blank',
      gdp: 19840,
      change: 11.47,
      linkTarget: '_blank',
      gdpAdjusted: 31749,
      changeAdjusted: 5.08
    },
    ET: {
      link: 'https://pt.wikipedia.org/wiki/ET',
      linkTarget: '_blank',
      gdp: 873,
      change: 8.82,
      linkTarget: '_blank',
      gdpAdjusted: 2161,
      changeAdjusted: 8.43
    },
    FM: {
      link: 'https://pt.wikipedia.org/wiki/FM',
      linkTarget: '_blank',
      gdp: 3200,
      change: 1.45,
      linkTarget: '_blank',
      gdpAdjusted: 3393,
      changeAdjusted: 1.37
    },
    FJ: {
      link: 'https://pt.wikipedia.org/wiki/FJ',
      linkTarget: '_blank',
      gdp: 5740,
      change: 7.44,
      linkTarget: '_blank',
      gdpAdjusted: 9777,
      changeAdjusted: 3.08
    },
    FI: {
      link: 'https://pt.wikipedia.org/wiki/FI',
      linkTarget: '_blank',
      gdp: 46017,
      change: 5.75,
      linkTarget: '_blank',
      gdpAdjusted: 44333,
      changeAdjusted: 2.63
    },
    FR: {
      link: 'https://pt.wikipedia.org/wiki/FR',
      linkTarget: '_blank',
      gdp: 39869,
      change: 4.35,
      linkTarget: '_blank',
      gdpAdjusted: 43760,
      changeAdjusted: 1.46
    },
    GA: {
      link: 'https://pt.wikipedia.org/wiki/GA',
      linkTarget: '_blank',
      gdp: 7972,
      change: 6.96,
      linkTarget: '_blank',
      gdpAdjusted: 19254,
      changeAdjusted: -1.33
    },
    GM: {
      link: 'https://pt.wikipedia.org/wiki/GM',
      linkTarget: '_blank',
      gdp: 480,
      change: 1.45,
      linkTarget: '_blank',
      gdpAdjusted: 1713,
      changeAdjusted: 0.56
    },
    GE: {
      link: 'https://pt.wikipedia.org/wiki/GE',
      linkTarget: '_blank',
      gdp: 4099,
      change: 5.86,
      linkTarget: '_blank',
      gdpAdjusted: 10747,
      changeAdjusted: 5.07
    },
    DE: {
      link: 'https://pt.wikipedia.org/wiki/DE',
      linkTarget: '_blank',
      gdp: 44550,
      change: 5.44,
      linkTarget: '_blank',
      gdpAdjusted: 50425,
      changeAdjusted: 2.07
    },
    GH: {
      link: 'https://pt.wikipedia.org/wiki/GH',
      linkTarget: '_blank',
      gdp: 1663,
      change: 7.18,
      linkTarget: '_blank',
      gdpAdjusted: 4729,
      changeAdjusted: 6.28
    },
    GR: {
      link: 'https://pt.wikipedia.org/wiki/GR',
      linkTarget: '_blank',
      gdp: 18637,
      change: 4.26,
      linkTarget: '_blank',
      gdpAdjusted: 27737,
      changeAdjusted: 1.56
    },
    GD: {
      link: 'https://pt.wikipedia.org/wiki/GD',
      linkTarget: '_blank',
      gdp: 10360,
      change: 5.1,
      linkTarget: '_blank',
      gdpAdjusted: 14926,
      changeAdjusted: 3.04
    },
    GT: {
      link: 'https://pt.wikipedia.org/wiki/GT',
      linkTarget: '_blank',
      gdp: 4472,
      change: 7.84,
      linkTarget: '_blank',
      gdpAdjusted: 8145,
      changeAdjusted: 0.81
    },
    GN: {
      link: 'https://pt.wikipedia.org/wiki/GN',
      linkTarget: '_blank',
      gdp: 749,
      change: 11.88,
      linkTarget: '_blank',
      gdpAdjusted: 2041,
      changeAdjusted: 4.09
    },
    GW: {
      link: 'https://pt.wikipedia.org/wiki/GW',
      linkTarget: '_blank',
      gdp: 794,
      change: 13.43,
      linkTarget: '_blank',
      gdpAdjusted: 1845,
      changeAdjusted: 3.57
    },
    GY: {
      link: 'https://pt.wikipedia.org/wiki/GY',
      linkTarget: '_blank',
      gdp: 4710,
      change: 3.24,
      linkTarget: '_blank',
      gdpAdjusted: 8161,
      changeAdjusted: 1.55
    },
    HT: {
      link: 'https://pt.wikipedia.org/wiki/HT',
      linkTarget: '_blank',
      gdp: 784,
      change: 3.96,
      linkTarget: '_blank',
      gdpAdjusted: 1815,
      changeAdjusted: -0.03
    },
    HN: {
      link: 'https://pt.wikipedia.org/wiki/HN',
      linkTarget: '_blank',
      gdp: 2766,
      change: 4.66,
      linkTarget: '_blank',
      gdpAdjusted: 5562,
      changeAdjusted: 3.17
    },
    HK: {
      link: 'https://pt.wikipedia.org/wiki/HK',
      linkTarget: '_blank',
      gdp: 46109,
      change: 6.01,
      linkTarget: '_blank',
      gdpAdjusted: 61393,
      changeAdjusted: 2.9
    },
    HU: {
      link: 'https://pt.wikipedia.org/wiki/HU',
      linkTarget: '_blank',
      gdp: 15531,
      change: 3.16,
      linkTarget: '_blank',
      gdpAdjusted: 29474,
      changeAdjusted: 4.32
    },
    IS: {
      link: 'https://pt.wikipedia.org/wiki/IS',
      linkTarget: '_blank',
      gdp: 70332,
      change: 16.46,
      linkTarget: '_blank',
      gdpAdjusted: 51841,
      changeAdjusted: 2.87
    },
    IN: {
      link: 'https://pt.wikipedia.org/wiki/IN',
      linkTarget: '_blank',
      gdp: 1983,
      change: 13.35,
      linkTarget: '_blank',
      gdpAdjusted: 7183,
      changeAdjusted: 5.43
    },
    ID: {
      link: 'https://pt.wikipedia.org/wiki/ID',
      linkTarget: '_blank',
      gdp: 3876,
      change: 7.53,
      linkTarget: '_blank',
      gdpAdjusted: 12377,
      changeAdjusted: 4.33
    },
    IR: {
      link: 'https://pt.wikipedia.org/wiki/IR',
      linkTarget: '_blank',
      gdp: 5305,
      change: 5.53,
      linkTarget: '_blank',
      gdpAdjusted: 20200,
      changeAdjusted: 3.24
    },
    IQ: {
      link: 'https://pt.wikipedia.org/wiki/IQ',
      linkTarget: '_blank',
      gdp: 5088,
      change: 12.24,
      linkTarget: '_blank',
      gdpAdjusted: 16954,
      changeAdjusted: -3.79
    },
    IE: {
      link: 'https://pt.wikipedia.org/wiki/IE',
      linkTarget: '_blank',
      gdp: 70638,
      change: 9.02,
      linkTarget: '_blank',
      gdpAdjusted: 75539,
      changeAdjusted: 6.92
    },
    IL: {
      link: 'https://pt.wikipedia.org/wiki/IL',
      linkTarget: '_blank',
      gdp: 40258,
      change: 8.24,
      linkTarget: '_blank',
      gdpAdjusted: 36340,
      changeAdjusted: 1.77
    },
    IT: {
      link: 'https://pt.wikipedia.org/wiki/IT',
      linkTarget: '_blank',
      gdp: 31984,
      change: 4.31,
      linkTarget: '_blank',
      gdpAdjusted: 38140,
      changeAdjusted: 1.59
    },
    CI: {
      link: 'https://pt.wikipedia.org/wiki/CI',
      linkTarget: '_blank',
      gdp: 1617,
      change: 8.14,
      linkTarget: '_blank',
      gdpAdjusted: 3883,
      changeAdjusted: 5.28
    },
    JM: {
      link: 'https://pt.wikipedia.org/wiki/JM',
      linkTarget: '_blank',
      gdp: 5048,
      change: 2.0,
      linkTarget: '_blank',
      gdpAdjusted: 9163,
      changeAdjusted: 0.67
    },
    JP: {
      link: 'https://pt.wikipedia.org/wiki/JP',
      linkTarget: '_blank',
      gdp: 38440,
      change: -1.4,
      linkTarget: '_blank',
      gdpAdjusted: 42832,
      changeAdjusted: 1.94
    },
    JO: {
      link: 'https://pt.wikipedia.org/wiki/JO',
      linkTarget: '_blank',
      gdp: 5678,
      change: 2.31,
      linkTarget: '_blank',
      gdpAdjusted: 12494,
      changeAdjusted: 0.13
    },
    KZ: {
      link: 'https://pt.wikipedia.org/wiki/KZ',
      linkTarget: '_blank',
      gdp: 8841,
      change: 18.57,
      linkTarget: '_blank',
      gdpAdjusted: 26252,
      changeAdjusted: 2.87
    },
    KE: {
      link: 'https://pt.wikipedia.org/wiki/KE',
      linkTarget: '_blank',
      gdp: 1702,
      change: 9.66,
      linkTarget: '_blank',
      gdpAdjusted: 3491,
      changeAdjusted: 2.29
    },
    KI: {
      link: 'https://pt.wikipedia.org/wiki/KI',
      linkTarget: '_blank',
      gdp: 1721,
      change: 6.42,
      linkTarget: '_blank',
      gdpAdjusted: 1976,
      changeAdjusted: 0.43
    },
    KW: {
      link: 'https://pt.wikipedia.org/wiki/KW',
      linkTarget: '_blank',
      gdp: 26005,
      change: 5.6,
      linkTarget: '_blank',
      gdpAdjusted: 66163,
      changeAdjusted: -4.31
    },
    KG: {
      link: 'https://pt.wikipedia.org/wiki/KG',
      linkTarget: '_blank',
      gdp: 1144,
      change: 7.19,
      linkTarget: '_blank',
      gdpAdjusted: 3667,
      changeAdjusted: 3.05
    },
    LA: {
      link: 'https://pt.wikipedia.org/wiki/LA',
      linkTarget: '_blank',
      gdp: 2543,
      change: 5.2,
      linkTarget: '_blank',
      gdpAdjusted: 7366,
      changeAdjusted: 5.38
    },
    LV: {
      link: 'https://pt.wikipedia.org/wiki/LV',
      linkTarget: '_blank',
      gdp: 15547,
      change: 10.98,
      linkTarget: '_blank',
      gdpAdjusted: 27644,
      changeAdjusted: 5.58
    },
    LB: {
      link: 'https://pt.wikipedia.org/wiki/LB',
      linkTarget: '_blank',
      gdp: 11408,
      change: 2.73,
      linkTarget: '_blank',
      gdpAdjusted: 19439,
      changeAdjusted: 0.63
    },
    LS: {
      link: 'https://pt.wikipedia.org/wiki/LS',
      linkTarget: '_blank',
      gdp: 1425,
      change: 12.94,
      linkTarget: '_blank',
      gdpAdjusted: 3581,
      changeAdjusted: 1.78
    },
    LR: {
      link: 'https://pt.wikipedia.org/wiki/LR',
      linkTarget: '_blank',
      gdp: 729,
      change: -2.12,
      linkTarget: '_blank',
      gdpAdjusted: 1354,
      changeAdjusted: -0.05
    },
    LY: {
      link: 'https://pt.wikipedia.org/wiki/LY',
      linkTarget: '_blank',
      gdp: 4859,
      change: 67.32,
      linkTarget: '_blank',
      gdpAdjusted: 9987,
      changeAdjusted: 69.48
    },
    LT: {
      link: 'https://pt.wikipedia.org/wiki/LT',
      linkTarget: '_blank',
      gdp: 16730,
      change: 12.14,
      linkTarget: '_blank',
      gdpAdjusted: 32299,
      changeAdjusted: 4.38
    },
    LU: {
      link: 'https://pt.wikipedia.org/wiki/LU',
      linkTarget: '_blank',
      gdp: 105803,
      change: 3.94,
      linkTarget: '_blank',
      gdpAdjusted: 106374,
      changeAdjusted: 2.27
    },
    MO: {
      link: 'https://pt.wikipedia.org/wiki/MO',
      linkTarget: '_blank',
      gdp: 77451,
      change: 10.1,
      linkTarget: '_blank',
      gdpAdjusted: 111629,
      changeAdjusted: 9.42
    },
    MK: {
      link: 'https://pt.wikipedia.org/wiki/MK',
      linkTarget: '_blank',
      gdp: 5474,
      change: 5.51,
      linkTarget: '_blank',
      gdpAdjusted: 14914,
      changeAdjusted: -0.06
    },
    MG: {
      link: 'https://pt.wikipedia.org/wiki/MG',
      linkTarget: '_blank',
      gdp: 448,
      change: 11.5,
      linkTarget: '_blank',
      gdpAdjusted: 1551,
      changeAdjusted: 1.37
    },
    MW: {
      link: 'https://pt.wikipedia.org/wiki/MW',
      linkTarget: '_blank',
      gdp: 324,
      change: 10.17,
      linkTarget: '_blank',
      gdpAdjusted: 1167,
      changeAdjusted: 1.13
    },
    MY: {
      link: 'https://pt.wikipedia.org/wiki/MY',
      linkTarget: '_blank',
      gdp: 9813,
      change: 4.68,
      linkTarget: '_blank',
      gdpAdjusted: 29041,
      changeAdjusted: 4.55
    },
    MV: {
      link: 'https://pt.wikipedia.org/wiki/MV',
      linkTarget: '_blank',
      gdp: 12527,
      change: 5.17,
      linkTarget: '_blank',
      gdpAdjusted: 19151,
      changeAdjusted: 2.98
    },
    ML: {
      link: 'https://pt.wikipedia.org/wiki/ML',
      linkTarget: '_blank',
      gdp: 811,
      change: 5.62,
      linkTarget: '_blank',
      gdpAdjusted: 2170,
      changeAdjusted: 2.31
    },
    MT: {
      link: 'https://pt.wikipedia.org/wiki/MT',
      linkTarget: '_blank',
      gdp: 27250,
      change: 8.83,
      linkTarget: '_blank',
      gdpAdjusted: 41945,
      changeAdjusted: 6.26
    },
    MH: {
      link: 'https://pt.wikipedia.org/wiki/MH',
      linkTarget: '_blank',
      gdp: 3625,
      change: 8.21,
      linkTarget: '_blank',
      gdpAdjusted: 3439,
      changeAdjusted: 1.83
    },
    MR: {
      link: 'https://pt.wikipedia.org/wiki/MR',
      linkTarget: '_blank',
      gdp: 1318,
      change: 5.15,
      linkTarget: '_blank',
      gdpAdjusted: 4444,
      changeAdjusted: 0.52
    },
    MU: {
      link: 'https://pt.wikipedia.org/wiki/MU',
      linkTarget: '_blank',
      gdp: 9794,
      change: 1.88,
      linkTarget: '_blank',
      gdpAdjusted: 21640,
      changeAdjusted: 3.67
    },
    MX: {
      link: 'https://pt.wikipedia.org/wiki/MX',
      linkTarget: '_blank',
      gdp: 9304,
      change: 5.64,
      linkTarget: '_blank',
      gdpAdjusted: 19903,
      changeAdjusted: 0.91
    },
    MD: {
      link: 'https://pt.wikipedia.org/wiki/MD',
      linkTarget: '_blank',
      gdp: 2280,
      change: 19.51,
      linkTarget: '_blank',
      gdpAdjusted: 5661,
      changeAdjusted: 4.24
    },
    MN: {
      link: 'https://pt.wikipedia.org/wiki/MN',
      linkTarget: '_blank',
      gdp: 3640,
      change: -0.75,
      linkTarget: '_blank',
      gdpAdjusted: 12979,
      changeAdjusted: 3.65
    },
    ME: {
      link: 'https://pt.wikipedia.org/wiki/ME',
      linkTarget: '_blank',
      gdp: 7647,
      change: 8.8,
      linkTarget: '_blank',
      gdpAdjusted: 17735,
      changeAdjusted: 4.16
    },
    MA: {
      link: 'https://pt.wikipedia.org/wiki/MA',
      linkTarget: '_blank',
      gdp: 3151,
      change: 4.89,
      linkTarget: '_blank',
      gdpAdjusted: 8567,
      changeAdjusted: 2.96
    },
    MZ: {
      link: 'https://pt.wikipedia.org/wiki/MZ',
      linkTarget: '_blank',
      gdp: 429,
      change: 9.5,
      linkTarget: '_blank',
      gdpAdjusted: 1244,
      changeAdjusted: 0.09
    },
    MM: {
      link: 'https://pt.wikipedia.org/wiki/MM',
      linkTarget: '_blank',
      gdp: 1264,
      change: 4.41,
      linkTarget: '_blank',
      gdpAdjusted: 6244,
      changeAdjusted: 5.82
    },
    NA: {
      link: 'https://pt.wikipedia.org/wiki/NA',
      linkTarget: '_blank',
      gdp: 5413,
      change: 14.96,
      linkTarget: '_blank',
      gdpAdjusted: 11312,
      changeAdjusted: -3.12
    },
    NR: {
      link: 'https://pt.wikipedia.org/wiki/NR',
      linkTarget: '_blank',
      gdp: 8575,
      change: 9.6,
      linkTarget: '_blank',
      gdpAdjusted: 12002,
      changeAdjusted: 1.22
    },
    NP: {
      link: 'https://pt.wikipedia.org/wiki/NP',
      linkTarget: '_blank',
      gdp: 834,
      change: 14.45,
      linkTarget: '_blank',
      gdpAdjusted: 2679,
      changeAdjusted: 6.41
    },
    NL: {
      link: 'https://pt.wikipedia.org/wiki/NL',
      linkTarget: '_blank',
      gdp: 48346,
      change: 5.89,
      linkTarget: '_blank',
      gdpAdjusted: 53635,
      changeAdjusted: 2.83
    },
    NZ: {
      link: 'https://pt.wikipedia.org/wiki/NZ',
      linkTarget: '_blank',
      gdp: 41593,
      change: 6.51,
      linkTarget: '_blank',
      gdpAdjusted: 38934,
      changeAdjusted: 2.03
    },
    NI: {
      link: 'https://pt.wikipedia.org/wiki/NI',
      linkTarget: '_blank',
      gdp: 2207,
      change: 2.57,
      linkTarget: '_blank',
      gdpAdjusted: 5849,
      changeAdjusted: 3.82
    },
    NE: {
      link: 'https://pt.wikipedia.org/wiki/NE',
      linkTarget: '_blank',
      gdp: 440,
      change: 6.29,
      linkTarget: '_blank',
      gdpAdjusted: 1164,
      changeAdjusted: 1.37
    },
    NG: {
      link: 'https://pt.wikipedia.org/wiki/NG',
      linkTarget: '_blank',
      gdp: 1994,
      change: -9.68,
      linkTarget: '_blank',
      gdpAdjusted: 5929,
      changeAdjusted: -1.76
    },
    NO: {
      link: 'https://pt.wikipedia.org/wiki/NO',
      linkTarget: '_blank',
      gdp: 74941,
      change: 6.07,
      linkTarget: '_blank',
      gdpAdjusted: 71831,
      changeAdjusted: 0.87
    },
    OM: {
      link: 'https://pt.wikipedia.org/wiki/OM',
      linkTarget: '_blank',
      gdp: 17973,
      change: 0.64,
      linkTarget: '_blank',
      gdpAdjusted: 45157,
      changeAdjusted: -2.23
    },
    PK: {
      link: 'https://pt.wikipedia.org/wiki/PK',
      linkTarget: '_blank',
      gdp: 1541,
      change: 6.95,
      linkTarget: '_blank',
      gdpAdjusted: 5358,
      changeAdjusted: 3.58
    },
    PW: {
      link: 'https://pt.wikipedia.org/wiki/PW',
      linkTarget: '_blank',
      gdp: 17096,
      change: 0.27,
      linkTarget: '_blank',
      gdpAdjusted: 15934,
      changeAdjusted: -2.06
    },
    PA: {
      link: 'https://pt.wikipedia.org/wiki/PA',
      linkTarget: '_blank',
      gdp: 15089,
      change: 5.35,
      linkTarget: '_blank',
      gdpAdjusted: 25351,
      changeAdjusted: 3.82
    },
    PG: {
      link: 'https://pt.wikipedia.org/wiki/PG',
      linkTarget: '_blank',
      gdp: 2861,
      change: 2.51,
      linkTarget: '_blank',
      gdpAdjusted: 3674,
      changeAdjusted: 0.46
    },
    PY: {
      link: 'https://pt.wikipedia.org/wiki/PY',
      linkTarget: '_blank',
      gdp: 4260,
      change: 6.47,
      linkTarget: '_blank',
      gdpAdjusted: 9826,
      changeAdjusted: 3.06
    },
    PE: {
      link: 'https://pt.wikipedia.org/wiki/PE',
      linkTarget: '_blank',
      gdp: 6199,
      change: 8.93,
      linkTarget: '_blank',
      gdpAdjusted: 13334,
      changeAdjusted: 1.31
    },
    PH: {
      link: 'https://pt.wikipedia.org/wiki/PH',
      linkTarget: '_blank',
      gdp: 2976,
      change: 0.78,
      linkTarget: '_blank',
      gdpAdjusted: 8315,
      changeAdjusted: 5.15
    },
    PL: {
      link: 'https://pt.wikipedia.org/wiki/PL',
      linkTarget: '_blank',
      gdp: 13822,
      change: 11.37,
      linkTarget: '_blank',
      gdpAdjusted: 29521,
      changeAdjusted: 4.73
    },
    PT: {
      link: 'https://pt.wikipedia.org/wiki/PT',
      linkTarget: '_blank',
      gdp: 21161,
      change: 3.68,
      linkTarget: '_blank',
      gdpAdjusted: 30417,
      changeAdjusted: 3.08
    },
    PR: {
      link: 'https://pt.wikipedia.org/wiki/PR',
      linkTarget: '_blank',
      gdp: 30488,
      change: -0.98,
      linkTarget: '_blank',
      gdpAdjusted: 37339,
      changeAdjusted: -2.35
    },
    QA: {
      link: 'https://pt.wikipedia.org/wiki/QA',
      linkTarget: '_blank',
      gdp: 60804,
      change: 4.39,
      linkTarget: '_blank',
      gdpAdjusted: 124529,
      changeAdjusted: -2.31
    },
    RO: {
      link: 'https://pt.wikipedia.org/wiki/RO',
      linkTarget: '_blank',
      gdp: 10757,
      change: 13.18,
      linkTarget: '_blank',
      gdpAdjusted: 24508,
      changeAdjusted: 7.49
    },
    RU: {
      link: 'https://pt.wikipedia.org/wiki/RU',
      linkTarget: '_blank',
      gdp: 10608,
      change: 19.19,
      linkTarget: '_blank',
      gdpAdjusted: 27834,
      changeAdjusted: 1.5
    },
    RW: {
      link: 'https://pt.wikipedia.org/wiki/RW',
      linkTarget: '_blank',
      gdp: 772,
      change: 5.2,
      linkTarget: '_blank',
      gdpAdjusted: 2080,
      changeAdjusted: 3.7
    },
    KN: {
      link: 'https://pt.wikipedia.org/wiki/KN',
      linkTarget: '_blank',
      gdp: 16296,
      change: 1.9,
      linkTarget: '_blank',
      gdpAdjusted: 26845,
      changeAdjusted: 1.71
    },
    LC: {
      link: 'https://pt.wikipedia.org/wiki/LC',
      linkTarget: '_blank',
      gdp: 9607,
      change: 1.99,
      linkTarget: '_blank',
      gdpAdjusted: 14450,
      changeAdjusted: 2.51
    },
    VC: {
      link: 'https://pt.wikipedia.org/wiki/VC',
      linkTarget: '_blank',
      gdp: 7270,
      change: 3.99,
      linkTarget: '_blank',
      gdpAdjusted: 11491,
      changeAdjusted: 0.7
    },
    WS: {
      link: 'https://pt.wikipedia.org/wiki/WS',
      linkTarget: '_blank',
      gdp: 4253,
      change: 5.93,
      linkTarget: '_blank',
      gdpAdjusted: 5740,
      changeAdjusted: 1.8
    },
    SM: {
      link: 'https://pt.wikipedia.org/wiki/SM',
      linkTarget: '_blank',
      gdp: 47406,
      change: 3.8,
      linkTarget: '_blank',
      gdpAdjusted: 59466,
      changeAdjusted: 1.65
    },
    ST: {
      link: 'https://pt.wikipedia.org/wiki/ST',
      linkTarget: '_blank',
      gdp: 1785,
      change: 5.7,
      linkTarget: '_blank',
      gdpAdjusted: 3180,
      changeAdjusted: 2.58
    },
    SA: {
      link: 'https://pt.wikipedia.org/wiki/SA',
      linkTarget: '_blank',
      gdp: 21120,
      change: 3.95,
      linkTarget: '_blank',
      gdpAdjusted: 54777,
      changeAdjusted: -2.63
    },
    SN: {
      link: 'https://pt.wikipedia.org/wiki/SN',
      linkTarget: '_blank',
      gdp: 1038,
      change: 8.73,
      linkTarget: '_blank',
      gdpAdjusted: 2727,
      changeAdjusted: 4.39
    },
    RS: {
      link: 'https://pt.wikipedia.org/wiki/RS',
      linkTarget: '_blank',
      gdp: 5899,
      change: 8.71,
      linkTarget: '_blank',
      gdpAdjusted: 15000,
      changeAdjusted: 1.83
    },
    SC: {
      link: 'https://pt.wikipedia.org/wiki/SC',
      linkTarget: '_blank',
      gdp: 15686,
      change: 2.97,
      linkTarget: '_blank',
      gdpAdjusted: 28779,
      changeAdjusted: 3.75
    },
    SL: {
      link: 'https://pt.wikipedia.org/wiki/SL',
      linkTarget: '_blank',
      gdp: 492,
      change: -5.88,
      linkTarget: '_blank',
      gdpAdjusted: 1553,
      changeAdjusted: 1.35
    },
    SG: {
      link: 'https://pt.wikipedia.org/wiki/SG',
      linkTarget: '_blank',
      gdp: 57713,
      change: 4.48,
      linkTarget: '_blank',
      gdpAdjusted: 93906,
      changeAdjusted: 2.22
    },
    SK: {
      link: 'https://pt.wikipedia.org/wiki/SK',
      linkTarget: '_blank',
      gdp: 17664,
      change: 6.73,
      linkTarget: '_blank',
      gdpAdjusted: 33025,
      changeAdjusted: 3.61
    },
    SI: {
      link: 'https://pt.wikipedia.org/wiki/SI',
      linkTarget: '_blank',
      gdp: 23654,
      change: 9.17,
      linkTarget: '_blank',
      gdpAdjusted: 34408,
      changeAdjusted: 4.93
    },
    SB: {
      link: 'https://pt.wikipedia.org/wiki/SB',
      linkTarget: '_blank',
      gdp: 2081,
      change: 1.18,
      linkTarget: '_blank',
      gdpAdjusted: 2157,
      changeAdjusted: 1.29
    },
    SO: {
      link: 'https://pt.wikipedia.org/wiki/SO',
      linkTarget: '_blank',
      gdp: 486,
      change: 6.38,
      linkTarget: '_blank',
      gdpAdjusted: 1229,
      changeAdjusted: -1.82
    },
    ZA: {
      link: 'https://pt.wikipedia.org/wiki/ZA',
      linkTarget: '_blank',
      gdp: 6180,
      change: 16.25,
      linkTarget: '_blank',
      gdpAdjusted: 13545,
      changeAdjusted: -0.07
    },
    KR: {
      link: 'https://pt.wikipedia.org/wiki/KR',
      linkTarget: '_blank',
      gdp: 29891,
      change: 8.56,
      linkTarget: '_blank',
      gdpAdjusted: 39434,
      changeAdjusted: 2.72
    },
    SS: {
      link: 'https://pt.wikipedia.org/wiki/SS',
      linkTarget: '_blank',
      gdp: 228,
      change: -18.73,
      linkTarget: '_blank',
      gdpAdjusted: 1489,
      changeAdjusted: -12.82
    },
    ES: {
      link: 'https://pt.wikipedia.org/wiki/ES',
      linkTarget: '_blank',
      gdp: 28359,
      change: 6.31,
      linkTarget: '_blank',
      gdpAdjusted: 38286,
      changeAdjusted: 3.01
    },
    LK: {
      link: 'https://pt.wikipedia.org/wiki/LK',
      linkTarget: '_blank',
      gdp: 4085,
      change: 6.95,
      linkTarget: '_blank',
      gdpAdjusted: 12811,
      changeAdjusted: 3.46
    },
    SD: {
      link: 'https://pt.wikipedia.org/wiki/SD',
      linkTarget: '_blank',
      gdp: 1428,
      change: -1.91,
      linkTarget: '_blank',
      gdpAdjusted: 4586,
      changeAdjusted: 0.82
    },
    SR: {
      link: 'https://pt.wikipedia.org/wiki/SR',
      linkTarget: '_blank',
      gdp: 5746,
      change: 0.76,
      linkTarget: '_blank',
      gdpAdjusted: 13876,
      changeAdjusted: -0.87
    },
    SZ: {
      link: 'https://pt.wikipedia.org/wiki/SZ',
      linkTarget: '_blank',
      gdp: 3915,
      change: 15.19,
      linkTarget: '_blank',
      gdpAdjusted: 9884,
      changeAdjusted: -0.67
    },
    SE: {
      link: 'https://pt.wikipedia.org/wiki/SE',
      linkTarget: '_blank',
      gdp: 53218,
      change: 3.39,
      linkTarget: '_blank',
      gdpAdjusted: 51475,
      changeAdjusted: 1.68
    },
    CH: {
      link: 'https://pt.wikipedia.org/wiki/CH',
      linkTarget: '_blank',
      gdp: 80591,
      change: 0.35,
      linkTarget: '_blank',
      gdpAdjusted: 61422,
      changeAdjusted: 0.24
    },
    TW: {
      link: 'https://pt.wikipedia.org/wiki/TW',
      linkTarget: '_blank',
      gdp: 24577,
      change: 9.03,
      linkTarget: '_blank',
      gdpAdjusted: 50294,
      changeAdjusted: 2.51
    },
    TJ: {
      link: 'https://pt.wikipedia.org/wiki/TJ',
      linkTarget: '_blank',
      gdp: 824,
      change: 2.54,
      linkTarget: '_blank',
      gdpAdjusted: 3211,
      changeAdjusted: 5.06
    },
    TZ: {
      link: 'https://pt.wikipedia.org/wiki/TZ',
      linkTarget: '_blank',
      gdp: 1034,
      change: 5.58,
      linkTarget: '_blank',
      gdpAdjusted: 3240,
      changeAdjusted: 2.96
    },
    TH: {
      link: 'https://pt.wikipedia.org/wiki/TH',
      linkTarget: '_blank',
      gdp: 6591,
      change: 10.39,
      linkTarget: '_blank',
      gdpAdjusted: 17855,
      changeAdjusted: 3.68
    },
    TL: {
      link: 'https://pt.wikipedia.org/wiki/TL',
      linkTarget: '_blank',
      gdp: 2104,
      change: 1.19,
      linkTarget: '_blank',
      gdpAdjusted: 5444,
      changeAdjusted: -2.67
    },
    TG: {
      link: 'https://pt.wikipedia.org/wiki/TG',
      linkTarget: '_blank',
      gdp: 611,
      change: 4.24,
      linkTarget: '_blank',
      gdpAdjusted: 1659,
      changeAdjusted: 1.95
    },
    TO: {
      link: 'https://pt.wikipedia.org/wiki/TO',
      linkTarget: '_blank',
      gdp: 4177,
      change: 5.56,
      linkTarget: '_blank',
      gdpAdjusted: 5608,
      changeAdjusted: 2.26
    },
    TT: {
      link: 'https://pt.wikipedia.org/wiki/TT',
      linkTarget: '_blank',
      gdp: 15769,
      change: -3.46,
      linkTarget: '_blank',
      gdpAdjusted: 31367,
      changeAdjusted: -2.58
    },
    TN: {
      link: 'https://pt.wikipedia.org/wiki/TN',
      linkTarget: '_blank',
      gdp: 3496,
      change: -5.24,
      linkTarget: '_blank',
      gdpAdjusted: 11755,
      changeAdjusted: 0.85
    },
    TR: {
      link: 'https://pt.wikipedia.org/wiki/TR',
      linkTarget: '_blank',
      gdp: 10512,
      change: -2.82,
      linkTarget: '_blank',
      gdpAdjusted: 26893,
      changeAdjusted: 5.68
    },
    TM: {
      link: 'https://pt.wikipedia.org/wiki/TM',
      linkTarget: '_blank',
      gdp: 6643,
      change: 3.59,
      linkTarget: '_blank',
      gdpAdjusted: 18126,
      changeAdjusted: 4.86
    },
    TV: {
      link: 'https://pt.wikipedia.org/wiki/TV',
      linkTarget: '_blank',
      gdp: 3638,
      change: 2.24,
      linkTarget: '_blank',
      gdpAdjusted: 3807,
      changeAdjusted: 2.34
    },
    UG: {
      link: 'https://pt.wikipedia.org/wiki/UG',
      linkTarget: '_blank',
      gdp: 699,
      change: 1.04,
      linkTarget: '_blank',
      gdpAdjusted: 2354,
      changeAdjusted: 2.86
    },
    UA: {
      link: 'https://pt.wikipedia.org/wiki/UA',
      linkTarget: '_blank',
      gdp: 2583,
      change: 17.46,
      linkTarget: '_blank',
      gdpAdjusted: 8713,
      changeAdjusted: 3.02
    },
    AE: {
      link: 'https://pt.wikipedia.org/wiki/AE',
      linkTarget: '_blank',
      gdp: 37226,
      change: 5.21,
      linkTarget: '_blank',
      gdpAdjusted: 67741,
      changeAdjusted: -0.86
    },
    GB: {
      link: 'https://pt.wikipedia.org/wiki/GB',
      linkTarget: '_blank',
      gdp: 39735,
      change: -1.96,
      linkTarget: '_blank',
      gdpAdjusted: 44117,
      changeAdjusted: 1.21
    },
    US: {
      link: 'https://pt.wikipedia.org/wiki/US',
      linkTarget: '_blank',
      gdp: 59501,
      change: 3.37,
      linkTarget: '_blank',
      gdpAdjusted: 59501,
      changeAdjusted: 1.48
    },
    UY: {
      link: 'https://pt.wikipedia.org/wiki/UY',
      linkTarget: '_blank',
      gdp: 16722,
      change: 11.02,
      linkTarget: '_blank',
      gdpAdjusted: 22371,
      changeAdjusted: 2.74
    },
    UZ: {
      link: 'https://pt.wikipedia.org/wiki/UZ',
      linkTarget: '_blank',
      gdp: 1491,
      change: -28.81,
      linkTarget: '_blank',
      gdpAdjusted: 6929,
      changeAdjusted: 3.89
    },
    VU: {
      link: 'https://pt.wikipedia.org/wiki/VU',
      linkTarget: '_blank',
      gdp: 3094,
      change: 6.51,
      linkTarget: '_blank',
      gdpAdjusted: 2739,
      changeAdjusted: 2.33
    },
    VE: {
      link: 'https://pt.wikipedia.org/wiki/VE',
      linkTarget: '_blank',
      gdp: 6684,
      change: -12.16,
      linkTarget: '_blank',
      gdpAdjusted: 12114,
      changeAdjusted: -15.3
    },
    VN: {
      link: 'https://pt.wikipedia.org/wiki/VN',
      linkTarget: '_blank',
      gdp: 2354,
      change: 8.37,
      linkTarget: '_blank',
      gdpAdjusted: 6913,
      changeAdjusted: 5.78
    },
    YE: {
      link: 'https://pt.wikipedia.org/wiki/YE',
      linkTarget: '_blank',
      gdp: 551,
      change: -23.23,
      linkTarget: '_blank',
      gdpAdjusted: 1287,
      changeAdjusted: -16.17
    },
    ZM: {
      link: 'https://pt.wikipedia.org/wiki/ZM',
      linkTarget: '_blank',
      gdp: 1480,
      change: 18.11,
      linkTarget: '_blank',
      gdpAdjusted: 3996,
      changeAdjusted: 0.95
    },
    ZW: {
      link: 'https://pt.wikipedia.org/wiki/ZW',
      linkTarget: '_blank',
      gdp: 1176,
      change: 5.78,
      linkTarget: '_blank',
      gdpAdjusted: 2283,
      changeAdjusted: 1.02
    }
  }
};
